/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Scouting;

import bwem.Area;
import ecgberht.GameState;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.unit.MineralPatch;

public class CheckMineralWalk
extends Action {
    private MineralPatch movingMineral = null;

    public CheckMineralWalk(String name, GameState gh) {
        super(name, gh);
    }

    private MineralPatch getCloserMineral() {
        double bestDist = Double.MAX_VALUE;
        MineralPatch closerMineral = null;
        for (MineralPatch mineralPatch : this.gameState.walkingMinerals) {
            double dist;
            if (!mineralPatch.isVisible() || this.gameState.chosenScout.getDistance(mineralPatch) <= 128 || (dist = mineralPatch.getDistance(this.gameState.scoutSLs.iterator().next().getLocation().toPosition())) > this.gameState.chosenScout.getDistance(this.gameState.scoutSLs.iterator().next().getLocation().toPosition())) continue;
            Area mineralArea = this.gameState.bwem.getMap().getArea(mineralPatch.getTilePosition());
            Area workerArea = this.gameState.bwem.getMap().getArea(this.gameState.chosenScout.getTilePosition());
            if (mineralPatch.equals(this.movingMineral) && mineralArea != null && mineralArea.equals(workerArea) || !(dist < bestDist)) continue;
            bestDist = dist;
            closerMineral = mineralPatch;
        }
        return closerMineral;
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.chosenScout == null) {
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.walkingMinerals.isEmpty() || this.gameState.scoutSLs.isEmpty()) {
                return BehavioralTree.State.SUCCESS;
            }
            if (this.movingMineral == null) {
                MineralPatch target = this.getCloserMineral();
                if (target == null) {
                    if (this.gameState.chosenScout.getOrderTarget() != null) {
                        this.gameState.chosenScout.move(this.gameState.scoutSLs.iterator().next().getLocation().toPosition());
                    }
                    return BehavioralTree.State.SUCCESS;
                }
                this.movingMineral = target;
                this.gameState.chosenScout.rightClick(target, false);
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.chosenScout.getDistance(this.movingMineral) < 32) {
                this.gameState.chosenScout.move(this.gameState.scoutSLs.iterator().next().getLocation().toPosition());
                this.movingMineral = null;
            }
            return BehavioralTree.State.SUCCESS;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

