/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Scouting;

import bwem.Base;
import ecgberht.GameState;
import ecgberht.UnitInfo;
import ecgberht.Util.BaseLocationComparator;
import ecgberht.Util.Util;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Worker;

public class CheckEnemyBaseVisible
extends Action {
    public CheckEnemyBaseVisible(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            List<PlayerUnit> enemies = this.gameState.getGame().getUnits(this.gameState.getIH().enemy());
            if (!enemies.isEmpty()) {
                for (UnitInfo u2 : this.gameState.unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
                    if (!(Util.broodWarDistance(this.gameState.chosenScout.getPosition(), u2.lastPosition) <= 500.0)) continue;
                    this.gameState.enemyMainBase = Util.getClosestBaseLocation(u2.lastPosition);
                    this.gameState.scoutSLs = new HashSet<Base>();
                    if (!this.gameState.getStrat().name.equals("PlasmaWraithHell")) {
                        this.gameState.chosenHarasser = (Worker)this.gameState.chosenScout;
                    }
                    this.gameState.chosenScout = null;
                    Util.sendText("!");
                    this.gameState.playSound("gearthere.mp3");
                    if (this.gameState.enemyStartBase == null) {
                        this.gameState.enemyBLs.clear();
                        this.gameState.enemyBLs.addAll(this.gameState.BLs);
                        this.gameState.enemyBLs.sort(new BaseLocationComparator(this.gameState.enemyMainBase));
                        if (this.gameState.firstScout) {
                            this.gameState.enemyStartBase = this.gameState.enemyMainBase;
                            this.gameState.enemyMainArea = this.gameState.enemyStartBase.getArea();
                            this.gameState.enemyNaturalBase = this.gameState.enemyBLs.get(1);
                            this.gameState.enemyNaturalArea = this.gameState.enemyNaturalBase.getArea();
                        }
                    }
                    return BehavioralTree.State.SUCCESS;
                }
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

