/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Scanner;

import bwem.Base;
import ecgberht.GameState;
import ecgberht.UnitInfo;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Random;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Conditional;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.Attacker;
import org.openbw.bwapi4j.unit.ComsatStation;

public class CheckScan
extends Conditional {
    public CheckScan(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.CSs.isEmpty()) {
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.frameCount - this.gameState.startCount > 40 + this.gameState.getIH().getLatency()) {
                for (ComsatStation u : this.gameState.CSs) {
                    if (u.getEnergy() < 50) continue;
                    for (UnitInfo e : this.gameState.unitStorage.getEnemyUnits().values()) {
                        if (!e.unit.isCloaked() && !e.burrowed || e.unit.isDetected() || !(e.unit instanceof Attacker) || this.gameState.sim.getSimulation((UnitInfo)e, (boolean)true).allies.stream().noneMatch(a -> a.unitType.canAttack())) continue;
                        this.gameState.checkScan = new MutablePair<ComsatStation, Position>(u, e.lastPosition);
                        return BehavioralTree.State.SUCCESS;
                    }
                }
            }
            ArrayList<Base> valid = new ArrayList<Base>();
            for (Base b : this.gameState.enemyBLs) {
                if (this.gameState.getGame().getBWMap().isVisible(b.getLocation()) || b.getArea().getAccessibleNeighbors().isEmpty() || this.gameState.enemyMainBase != null && this.gameState.enemyMainBase.getLocation().equals(b.getLocation())) continue;
                valid.add(b);
            }
            if (valid.isEmpty()) {
                return BehavioralTree.State.FAILURE;
            }
            for (ComsatStation u : this.gameState.CSs) {
                if (u.getEnergy() != 200) continue;
                Random random = new Random();
                this.gameState.checkScan = new MutablePair<ComsatStation, Position>(u, Util.getUnitCenterPosition(((Base)valid.get(random.nextInt(valid.size()))).getLocation().toPosition(), this.gameState.enemyRace.getCenter()));
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

