/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Repair;

import ecgberht.GameState;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.Worker;

public class ChooseRepairer
extends Action {
    public ChooseRepairer(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            SCV closestWorker = null;
            Position chosen = this.gameState.chosenUnitRepair.getPosition();
            int frame = this.gameState.frameCount;
            for (Worker u : this.gameState.workerIdle) {
                if (u.getLastCommandFrame() == frame || closestWorker != null && !(u.getDistance(chosen) < closestWorker.getDistance(chosen))) continue;
                closestWorker = (SCV)u;
            }
            for (Worker u : this.gameState.workerMining.keySet()) {
                if (u.getLastCommandFrame() == frame || closestWorker != null && !(u.getDistance(chosen) < closestWorker.getDistance(chosen)) || u.isCarryingMinerals()) continue;
                closestWorker = (SCV)u;
            }
            if (closestWorker != null) {
                this.gameState.chosenRepairer = closestWorker;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

