/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Defense;

import ecgberht.GameState;
import ecgberht.IntelligenceAgency;
import ecgberht.Squad;
import ecgberht.UnitInfo;
import ecgberht.Util.MutablePair;
import java.util.Map;
import java.util.TreeSet;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.PhotonCannon;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Pylon;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Worker;

public class SendDefenders
extends Action {
    public SendDefenders(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            int n;
            boolean bl;
            boolean air_only = true;
            boolean cannon_rush = false;
            for (Unit unit : this.gameState.enemyInBase) {
                if (unit.isFlying() || ((PlayerUnit)unit).isCloaked()) continue;
                if (!cannon_rush && (unit instanceof Pylon || unit instanceof PhotonCannon)) {
                    cannon_rush = true;
                }
                air_only = false;
            }
            TreeSet<UnitInfo> friends = new TreeSet<UnitInfo>();
            for (Squad squad : this.gameState.sqManager.squads.values()) {
                friends.addAll(squad.members);
            }
            boolean bl2 = false;
            if (!this.gameState.DBs.isEmpty()) {
                for (Bunker b : this.gameState.DBs.keySet()) {
                    friends.add(this.gameState.unitStorage.getAllyUnits().get(b));
                }
                bl = true;
            }
            int n2 = 6;
            if (this.gameState.enemyInBase.size() == 1 && this.gameState.enemyInBase.iterator().next() instanceof Worker) {
                n = 1;
            }
            MutablePair<Boolean, Boolean> battleWin = new MutablePair<Boolean, Boolean>(true, false);
            if (n != 1 && IntelligenceAgency.enemyIsRushing() && this.gameState.enemyInBase.size() + friends.size() < 40) {
                battleWin = this.gameState.sim.simulateDefenseBattle(friends, this.gameState.enemyInBase, 150, bl);
            }
            if (cannon_rush) {
                battleWin.first = false;
            }
            int frame = this.gameState.frameCount;
            int notFound = 0;
            if (!(air_only || ((Boolean)battleWin.first).booleanValue() && !((Boolean)battleWin.second).booleanValue() && n != 1)) {
                Position chosen;
                Worker closestWorker;
                while (this.gameState.workerDefenders.size() + notFound < n && !this.gameState.workerIdle.isEmpty()) {
                    closestWorker = null;
                    chosen = this.gameState.attackPosition;
                    for (Worker worker : this.gameState.workerIdle) {
                        if (worker.getLastCommandFrame() == frame || closestWorker != null && !(worker.getDistance(chosen) < closestWorker.getDistance(chosen))) continue;
                        closestWorker = worker;
                    }
                    if (closestWorker != null) {
                        this.gameState.workerDefenders.put(closestWorker, null);
                        this.gameState.workerIdle.remove(closestWorker);
                        continue;
                    }
                    ++notFound;
                }
                notFound = 0;
                while (this.gameState.workerDefenders.size() + notFound < n && !this.gameState.workerMining.isEmpty()) {
                    closestWorker = null;
                    chosen = this.gameState.attackPosition;
                    for (Map.Entry entry : this.gameState.workerMining.entrySet()) {
                        if (((Worker)entry.getKey()).getLastCommandFrame() == frame || closestWorker != null && !(((Worker)entry.getKey()).getDistance(chosen) < closestWorker.getDistance(chosen))) continue;
                        closestWorker = (Worker)entry.getKey();
                    }
                    if (closestWorker != null) {
                        if (!this.gameState.workerMining.containsKey(closestWorker)) continue;
                        MineralPatch mineral = this.gameState.workerMining.get(closestWorker);
                        this.gameState.workerDefenders.put(closestWorker, null);
                        if (this.gameState.mineralsAssigned.containsKey(mineral)) {
                            --this.gameState.mining;
                            this.gameState.mineralsAssigned.put(mineral, this.gameState.mineralsAssigned.get(mineral) - 1);
                        }
                        this.gameState.workerMining.remove(closestWorker);
                        continue;
                    }
                    ++notFound;
                }
                for (Map.Entry<Worker, Position> u : this.gameState.workerDefenders.entrySet()) {
                    Unit unit;
                    if (frame == u.getKey().getLastCommandFrame() || this.gameState.attackPosition == null) continue;
                    this.gameState.workerDefenders.put(u.getKey(), this.gameState.attackPosition);
                    if (this.gameState.enemyInBase.size() == 1 && this.gameState.enemyInBase.iterator().next() instanceof Worker) {
                        Unit scouter = this.gameState.enemyInBase.iterator().next();
                        Unit unit2 = u.getKey().getOrderTarget();
                        if (unit2 != null && unit2.equals(scouter)) continue;
                        u.getKey().attack(scouter);
                        continue;
                    }
                    Position closestDefense = null;
                    if (this.gameState.learningManager.isNaughty()) {
                        if (!this.gameState.DBs.isEmpty()) {
                            closestDefense = this.gameState.DBs.keySet().iterator().next().getPosition();
                        }
                        if (closestDefense == null) {
                            closestDefense = this.gameState.getNearestCC(u.getKey().getPosition(), false);
                        }
                        if (closestDefense != null && u.getKey().getDistance(closestDefense) > (double)UnitType.Terran_Marine.groundWeapon().maxRange() * 0.95) {
                            u.getKey().move(closestDefense);
                            continue;
                        }
                    }
                    if ((unit = this.gameState.getUnitToAttack(u.getKey(), this.gameState.enemyInBase)) != null) {
                        Unit lastTarget = u.getKey().getOrderTarget();
                        if (lastTarget != null && lastTarget.equals(unit)) continue;
                        u.getKey().attack(unit);
                        continue;
                    }
                    Position lastTargetPosition = u.getKey().getOrderTargetPosition();
                    if (lastTargetPosition != null && lastTargetPosition.equals(this.gameState.attackPosition)) continue;
                    u.getKey().attack(this.gameState.attackPosition);
                }
            } else if (!this.gameState.getStrat().name.equals("ProxyBBS") && !this.gameState.getStrat().name.equals("ProxyEightRax")) {
                for (Map.Entry<Integer, Squad> u : this.gameState.sqManager.squads.entrySet()) {
                    if (this.gameState.attackPosition != null) {
                        u.getValue().giveAttackOrder(this.gameState.attackPosition);
                        u.getValue().status = Squad.Status.DEFENSE;
                        continue;
                    }
                    u.getValue().status = Squad.Status.IDLE;
                    u.getValue().attack = null;
                }
            }
            this.gameState.attackPosition = null;
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

