/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Defense;

import bwem.Area;
import bwem.Base;
import ecgberht.GameState;
import ecgberht.Squad;
import ecgberht.UnitInfo;
import ecgberht.Util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Conditional;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.CommandCenter;
import org.openbw.bwapi4j.unit.Loadable;
import org.openbw.bwapi4j.unit.Overlord;
import org.openbw.bwapi4j.unit.ResearchingFacility;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Worker;

public class CheckPerimeter
extends Conditional {
    public CheckPerimeter(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            this.gameState.enemyInBase.clear();
            this.gameState.defense = false;
            TreeSet<Unit> enemyInvaders = new TreeSet<Unit>(this.gameState.enemyCombatUnitMemory);
            for (UnitInfo unitInfo : this.gameState.unitStorage.getEnemyUnits().values().stream().filter(u -> u.unitType.isBuilding()).collect(Collectors.toSet())) {
                if (!unitInfo.unitType.canAttack() && unitInfo.unitType != UnitType.Protoss_Pylon && !unitInfo.unitType.canProduce() && !unitInfo.unitType.isRefinery()) continue;
                enemyInvaders.add(unitInfo.unit);
            }
            block3: for (Unit unit : enemyInvaders) {
                UnitType uType = unit.getType();
                if (!(unit instanceof Building) && (!uType.canAttack() && !uType.isSpellcaster() && !(unit instanceof Loadable) || uType == UnitType.Zerg_Scourge || uType == UnitType.Terran_Valkyrie || uType == UnitType.Protoss_Corsair || unit instanceof Overlord)) continue;
                Area area = this.gameState.bwem.getMap().getArea(unit.getTilePosition());
                if (area != null) {
                    Iterator<Object> myMainArea = this.gameState.mainCC != null ? ((Base)this.gameState.mainCC.first).getArea() : null;
                    Area area2 = this.gameState.naturalArea;
                    for (Base b : this.gameState.CCs.keySet()) {
                        if (!b.getArea().equals(area) || myMainArea != null && !b.getArea().equals(myMainArea) && area2 != null && !b.getArea().equals(area2)) continue;
                        this.gameState.enemyInBase.add(unit);
                        break;
                    }
                }
                for (Map.Entry<SCV, Building> entry : this.gameState.workerTask.entrySet()) {
                    int dist;
                    int n = dist = entry.getValue() instanceof CommandCenter ? 500 : 200;
                    if (!(Util.broodWarDistance(unit.getPosition(), entry.getValue().getPosition()) <= (double)dist)) continue;
                    this.gameState.enemyInBase.add(unit);
                    break;
                }
                for (Unit unit2 : this.gameState.CCs.values()) {
                    if (!(Util.broodWarDistance(unit.getPosition(), unit2.getPosition()) <= 500.0)) continue;
                    this.gameState.enemyInBase.add(unit);
                    break;
                }
                for (Unit unit3 : this.gameState.DBs.keySet()) {
                    if (!(Util.broodWarDistance(unit.getPosition(), unit3.getPosition()) <= 200.0)) continue;
                    this.gameState.enemyInBase.add(unit);
                    break;
                }
                for (Unit unit4 : this.gameState.SBs) {
                    if (!(Util.broodWarDistance(unit.getPosition(), unit4.getPosition()) <= 200.0)) continue;
                    this.gameState.enemyInBase.add(unit);
                    break;
                }
                for (ResearchingFacility researchingFacility : this.gameState.UBs) {
                    if (!(Util.broodWarDistance(unit.getPosition(), researchingFacility.getPosition()) <= 200.0)) continue;
                    this.gameState.enemyInBase.add(unit);
                    break;
                }
                if (this.gameState.getStrat().name.equals("ProxyBBS") || this.gameState.getStrat().name.equals("ProxyEightRax")) continue;
                for (Unit unit5 : this.gameState.MBs) {
                    if (!(Util.broodWarDistance(unit.getPosition(), unit5.getPosition()) <= 200.0)) continue;
                    this.gameState.enemyInBase.add(unit);
                    continue block3;
                }
            }
            if (!this.gameState.enemyInBase.isEmpty()) {
                this.gameState.defense = true;
                return BehavioralTree.State.SUCCESS;
            }
            int cFrame = this.gameState.frameCount;
            ArrayList<Worker> arrayList = new ArrayList<Worker>();
            for (Worker worker : this.gameState.workerDefenders.keySet()) {
                Position closestDefense;
                if (worker.getLastCommandFrame() == cFrame) continue;
                if (this.gameState.learningManager.isNaughty() && !this.gameState.DBs.isEmpty()) {
                    closestDefense = this.gameState.DBs.keySet().iterator().next().getPosition();
                    worker.move(closestDefense);
                    arrayList.add(worker);
                    continue;
                }
                closestDefense = this.gameState.getNearestCC(worker.getPosition(), false);
                if (closestDefense == null) continue;
                worker.move(closestDefense);
                arrayList.add(worker);
            }
            for (Worker worker : arrayList) {
                worker.stop(false);
                this.gameState.workerDefenders.remove(worker);
                this.gameState.workerIdle.add(worker);
            }
            for (Squad squad : this.gameState.sqManager.squads.values()) {
                if (squad.status != Squad.Status.DEFENSE) continue;
                Position closestCC = this.gameState.getNearestCC(squad.getSquadCenter(), false);
                if (closestCC != null) {
                    Area area = this.gameState.bwem.getMap().getArea(squad.getSquadCenter().toTilePosition());
                    Area regCC = this.gameState.bwem.getMap().getArea(closestCC.toTilePosition());
                    if (area != null && regCC != null && !area.equals(regCC)) {
                        if (!this.gameState.DBs.isEmpty() && this.gameState.CCs.size() == 1) {
                            squad.giveMoveOrder(this.gameState.DBs.keySet().iterator().next().getPosition());
                        } else {
                            squad.giveMoveOrder(Util.getClosestChokepoint(squad.getSquadCenter()).getCenter().toPosition());
                        }
                        squad.status = Squad.Status.IDLE;
                        squad.attack = null;
                        continue;
                    }
                    squad.status = Squad.Status.IDLE;
                    squad.attack = null;
                    continue;
                }
                squad.status = Squad.Status.IDLE;
                squad.attack = null;
            }
            this.gameState.defense = false;
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

