/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.BuildingLot;

import ecgberht.GameState;
import java.util.Map;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.Worker;

public class ChooseBlotWorker
extends Action {
    public ChooseBlotWorker(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            Worker closestWorker = null;
            Position chosen = this.gameState.chosenBuildingLot.getPosition();
            if (!this.gameState.workerIdle.isEmpty()) {
                for (Worker worker : this.gameState.workerIdle) {
                    if (closestWorker != null && !(worker.getDistance(chosen) < closestWorker.getDistance(chosen))) continue;
                    closestWorker = worker;
                }
            }
            if (!this.gameState.workerMining.isEmpty()) {
                for (Map.Entry entry : this.gameState.workerMining.entrySet()) {
                    if (closestWorker != null && !(((Worker)entry.getKey()).getDistance(chosen) < closestWorker.getDistance(chosen)) || ((Worker)entry.getKey()).isCarryingMinerals()) continue;
                    closestWorker = (Worker)entry.getKey();
                }
            }
            if (closestWorker != null) {
                this.gameState.chosenWorker = closestWorker;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

