/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import ecgberht.GameState;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.Worker;

public class Move
extends Action {
    public Move(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            Worker chosen = this.gameState.chosenWorker;
            Position realEnd = Util.getUnitCenterPosition(this.gameState.chosenPosition.toPosition(), this.gameState.chosenToBuild);
            if (chosen.move(realEnd)) {
                if (this.gameState.workerIdle.contains(chosen)) {
                    this.gameState.workerIdle.remove(chosen);
                } else if (this.gameState.workerMining.containsKey(chosen)) {
                    MineralPatch mineral = this.gameState.workerMining.get(chosen);
                    this.gameState.workerMining.remove(chosen);
                    if (this.gameState.mineralsAssigned.containsKey(mineral)) {
                        --this.gameState.mining;
                        this.gameState.mineralsAssigned.put(mineral, this.gameState.mineralsAssigned.get(mineral) - 1);
                    }
                }
                if (this.gameState.chosenToBuild == UnitType.Terran_Command_Center && this.gameState.bwem.getMap().getArea(this.gameState.chosenPosition).equals(this.gameState.naturalArea) && this.gameState.naturalChoke != null) {
                    this.gameState.defendPosition = this.gameState.naturalChoke.getCenter().toPosition();
                }
                this.gameState.workerBuild.put((SCV)chosen, new MutablePair<UnitType, TilePosition>(this.gameState.chosenToBuild, this.gameState.chosenPosition));
                MutablePair<Integer, Integer> mutablePair = this.gameState.deltaCash;
                mutablePair.first = (Integer)mutablePair.first + this.gameState.chosenToBuild.mineralPrice();
                mutablePair = this.gameState.deltaCash;
                mutablePair.second = (Integer)mutablePair.second + this.gameState.chosenToBuild.gasPrice();
                this.gameState.chosenWorker = null;
                this.gameState.chosenToBuild = UnitType.None;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

