/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import bwem.Area;
import ecgberht.GameState;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.unit.Worker;

public class ChooseWorker
extends Action {
    public ChooseWorker(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            Area workerArea;
            Worker closestWorker = null;
            int frame = this.gameState.frameCount;
            Position chosen = this.gameState.chosenPosition.toPosition();
            Area posArea = this.gameState.bwem.getMap().getArea(this.gameState.chosenPosition);
            if (!this.gameState.workerIdle.isEmpty()) {
                for (Worker u : this.gameState.workerIdle) {
                    if (u.getLastCommandFrame() == frame || (workerArea = this.gameState.bwem.getMap().getArea(u.getTilePosition())) == null || posArea != null && !posArea.equals(workerArea) && !posArea.isAccessibleFrom(workerArea) || closestWorker != null && !(u.getDistance(chosen) < closestWorker.getDistance(chosen))) continue;
                    closestWorker = u;
                }
            }
            if (!this.gameState.workerMining.isEmpty()) {
                for (Worker u : this.gameState.workerMining.keySet()) {
                    if (u.getLastCommandFrame() == frame || (workerArea = this.gameState.bwem.getMap().getArea(u.getTilePosition())) == null || posArea != null && !posArea.equals(workerArea) && !posArea.isAccessibleFrom(workerArea) || closestWorker != null && !(u.getDistance(chosen) < closestWorker.getDistance(chosen)) || u.isCarryingMinerals()) continue;
                    closestWorker = u;
                }
            }
            if (closestWorker != null) {
                this.gameState.chosenWorker = closestWorker;
                return BehavioralTree.State.SUCCESS;
            }
            return BehavioralTree.State.FAILURE;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

