/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import ecgberht.GameState;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import java.util.Map;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Barracks;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Refinery;
import org.openbw.bwapi4j.unit.VespeneGeyser;

public class ChooseRefinery
extends Action {
    public ChooseRefinery(String name, GameState gh) {
        super(name, gh);
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            String strat = this.gameState.getStrat().name;
            if (this.gameState.getPlayer().supplyUsed() < this.gameState.getStrat().supplyForFirstRefinery || (Integer)this.gameState.getCash().second >= 300) {
                return BehavioralTree.State.FAILURE;
            }
            if ((strat.equals("BioGreedyFE") || strat.equals("FullBio") || strat.equals("FullBioFE")) && (Integer)this.gameState.getCash().second >= 150) {
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.getStrat().techToResearch.contains(TechType.Tank_Siege_Mode) && (Integer)this.gameState.getCash().second >= 250) {
                return BehavioralTree.State.FAILURE;
            }
            if (this.gameState.refineriesAssigned.size() == 1) {
                boolean found = false;
                for (MutablePair<UnitType, TilePosition> mutablePair : this.gameState.workerBuild.values()) {
                    if (mutablePair.first != UnitType.Terran_Barracks) continue;
                    found = true;
                    break;
                }
                for (Building building : this.gameState.workerTask.values()) {
                    if (!(building instanceof Barracks)) continue;
                    found = true;
                    break;
                }
                if (this.gameState.MBs.isEmpty() && !found) {
                    return BehavioralTree.State.FAILURE;
                }
            }
            int count = 0;
            VespeneGeyser geyser = null;
            for (Map.Entry<VespeneGeyser, Boolean> entry : this.gameState.vespeneGeysers.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    ++count;
                    continue;
                }
                geyser = entry.getKey();
            }
            if (count == this.gameState.vespeneGeysers.size()) {
                return BehavioralTree.State.FAILURE;
            }
            for (MutablePair<UnitType, TilePosition> mutablePair : this.gameState.workerBuild.values()) {
                if (mutablePair.first != UnitType.Terran_Refinery) continue;
                return BehavioralTree.State.FAILURE;
            }
            for (Building building : this.gameState.workerTask.values()) {
                if (!(building instanceof Refinery) || geyser == null || !building.getTilePosition().equals(geyser.getTilePosition())) continue;
                return BehavioralTree.State.FAILURE;
            }
            if ((strat.equals("BioGreedyFE") || strat.equals("MechGreedyFE") || strat.equals("BioMechGreedyFE")) && !this.gameState.refineriesAssigned.isEmpty() && Util.getNumberCCs() <= 2 && Util.countUnitTypeSelf(UnitType.Terran_SCV) < 30) {
                return BehavioralTree.State.FAILURE;
            }
            this.gameState.chosenToBuild = UnitType.Terran_Refinery;
            return BehavioralTree.State.SUCCESS;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

