/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.BehaviourTrees.Build;

import bwem.Area;
import ecgberht.GameState;
import ecgberht.Util.MutablePair;
import java.util.Map;
import org.iaie.btree.BehavioralTree;
import org.iaie.btree.task.leaf.Action;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.Unit;

public class CheckMineralWalkGoldRush
extends Action {
    public CheckMineralWalkGoldRush(String name, GameState gh) {
        super(name, gh);
    }

    private MineralPatch getCloserMineral(Map.Entry<SCV, MutablePair<UnitType, TilePosition>> entry) {
        double bestDist = Double.MAX_VALUE;
        MineralPatch closerMineral = null;
        SCV scv = entry.getKey();
        Position buildTarget = ((TilePosition)entry.getValue().second).toPosition();
        for (MineralPatch mineralPatch : this.gameState.walkingMinerals) {
            double dist;
            if (!mineralPatch.isVisible() || scv.getDistance(mineralPatch) <= 128 || (dist = mineralPatch.getDistance(buildTarget) * 1.2) > scv.getDistance(buildTarget)) continue;
            Area mineralArea = this.gameState.bwem.getMap().getArea(mineralPatch.getTilePosition());
            Area workerArea = this.gameState.bwem.getMap().getArea(scv.getTilePosition());
            if (mineralPatch.equals(scv.getTargetUnit()) && mineralArea != null && mineralArea.equals(workerArea) || !(dist < bestDist)) continue;
            bestDist = dist;
            closerMineral = mineralPatch;
        }
        return closerMineral;
    }

    @Override
    public BehavioralTree.State execute() {
        try {
            if (this.gameState.walkingMinerals.isEmpty()) {
                return BehavioralTree.State.SUCCESS;
            }
            for (Map.Entry<SCV, MutablePair<UnitType, TilePosition>> u : this.gameState.workerBuild.entrySet()) {
                if (u.getValue().first != UnitType.Terran_Command_Center) continue;
                SCV scv = u.getKey();
                Unit movingMineral = u.getKey().getTargetUnit();
                if (movingMineral == null) {
                    MineralPatch target = this.getCloserMineral(u);
                    if (target == null) {
                        if (scv.getOrderTarget() == null || scv.getOrder() == Order.Move) continue;
                        scv.move(((TilePosition)u.getValue().second).toPosition());
                        continue;
                    }
                    if (target.equals(scv.getTargetUnit())) continue;
                    scv.rightClick(target, false);
                    continue;
                }
                if (scv.getDistance(movingMineral) >= 32) continue;
                scv.move(((TilePosition)u.getValue().second).toPosition());
            }
            return BehavioralTree.State.SUCCESS;
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName());
            e.printStackTrace();
            return BehavioralTree.State.ERROR;
        }
    }
}

