/*
 * Decompiled with CFR 0.152.
 */
package ecgberht;

import bwem.Area;
import bwem.BWEM;
import bwem.Base;
import ecgberht.Ecgberht;
import ecgberht.Util.Util;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.ResourceDepot;
import org.openbw.bwapi4j.unit.Unit;

public class BaseManager {
    private Map<Base, Garrison> garrisons = new HashMap<Base, Garrison>();

    BaseManager(BWEM bwem) {
        bwem.getMap().getBases().forEach(b -> this.garrisons.put((Base)b, new Garrison((Base)b)));
        this.updateGarrisons();
    }

    void updateGarrisons() {
        for (Garrison g : this.garrisons.values()) {
            if (!Ecgberht.getGs().getGame().getBWMap().isVisible(g.tile)) continue;
            g.lastFrameVisible = Ecgberht.getGs().frameCount;
        }
    }

    void onCreate(ResourceDepot depot) {
        Base b = Util.getClosestBaseLocation(depot.getPosition());
        Garrison g = this.garrisons.get(b);
        g.lastFrameVisible = Ecgberht.getGs().frameCount;
        g.player = depot.getPlayer();
        g.depot = depot;
    }

    void onDestroy(ResourceDepot depot) {
        Base b = Util.getClosestBaseLocation(depot.getPosition());
        Garrison g = this.garrisons.get(b);
        g.lastFrameVisible = Ecgberht.getGs().frameCount;
        g.player = null;
        g.depot = null;
    }

    public List<Garrison> getMyBases() {
        return this.garrisons.values().stream().filter(u -> Ecgberht.getGs().self.equals(u.player)).collect(Collectors.toList());
    }

    public List<Garrison> getEnemyBases() {
        return this.garrisons.values().stream().filter(u -> Ecgberht.getGs().getIH().enemy().equals(u.player)).collect(Collectors.toList());
    }

    public List<Garrison> getEnemyBasesSorted() {
        return this.garrisons.values().stream().filter(u -> Ecgberht.getGs().getIH().enemy().equals(u.player)).sorted(Comparator.comparing(Garrison::frameVisibleDiff).reversed()).collect(Collectors.toList());
    }

    public List<Garrison> getScoutingBasesSorted() {
        return this.garrisons.values().stream().filter(u -> u.player == null).sorted(Comparator.comparing(Garrison::frameVisibleDiff).reversed()).collect(Collectors.toList());
    }

    public class Garrison {
        public Base base;
        public TilePosition tile;
        public Set<MineralPatch> minerals = new TreeSet<MineralPatch>();
        public Map<Unit, Boolean> geysers = new TreeMap<Unit, Boolean>();
        public Area area;
        public Player player;
        public boolean starting;
        public boolean island;
        public int lastFrameVisible = 0;
        public ResourceDepot depot = null;

        Garrison(Base bwemBase) {
            this.base = bwemBase;
            this.tile = this.base.getLocation();
            this.base.getMinerals().forEach(t -> this.minerals.add((MineralPatch)t.getUnit()));
            this.base.getGeysers().forEach(t -> this.geysers.put(t.getUnit(), false));
            this.area = this.base.getArea();
            this.starting = this.base.isStartingLocation() || Ecgberht.getGs().getGame().getBWMap().getStartPositions().contains(this.tile);
            this.island = this.area.getAccessibleNeighbors().isEmpty();
            if (Ecgberht.getGs().self.getStartLocation().equals(this.tile)) {
                this.player = Ecgberht.getGs().self;
            }
            this.lastFrameVisible = Ecgberht.getGs().frameCount;
        }

        int frameVisibleDiff() {
            return Ecgberht.getGs().frameCount - this.lastFrameVisible;
        }
    }
}

