/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Agents;

import ecgberht.Agents.Agent;
import ecgberht.Ecgberht;
import ecgberht.Simulation.SimInfo;
import ecgberht.UnitInfo;
import ecgberht.Util.Util;
import ecgberht.Util.UtilMicro;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Weapon;
import org.openbw.bwapi4j.unit.Wraith;

public class WraithAgent
extends Agent
implements Comparable<Unit> {
    public Wraith unit;
    public String name;
    private Set<UnitInfo> airAttackers = new TreeSet<UnitInfo>();

    public WraithAgent(Unit unit, String name) {
        super(unit);
        this.unit = (Wraith)unit;
        this.name = name;
    }

    @Override
    public boolean runAgent() {
        try {
            if (!this.unit.exists() || this.unitInfo == null) {
                return true;
            }
            this.actualFrame = Ecgberht.getGs().frameCount;
            this.frameLastOrder = this.unit.getLastCommandFrame();
            this.airAttackers.clear();
            if (this.frameLastOrder == this.actualFrame) {
                return false;
            }
            Position attack = this.getBestBaseToHarass();
            UnitInfo closestThreat = null;
            double bestDist = Double.MAX_VALUE;
            SimInfo airSim = Ecgberht.getGs().sim.getSimulation(this.unitInfo, SimInfo.SimType.AIR);
            this.airAttackers = airSim.enemies;
            for (UnitInfo u : this.airAttackers) {
                double predictedDist = this.unitInfo.getPredictedDistance(u);
                if (!(predictedDist < bestDist)) continue;
                closestThreat = u;
                bestDist = predictedDist;
            }
            Set<UnitInfo> mainTargets = Ecgberht.getGs().sim.getSimulation((UnitInfo)this.unitInfo, (SimInfo.SimType)SimInfo.SimType.MIX).enemies;
            UnitInfo harassed = this.chooseHarassTarget(mainTargets);
            if (closestThreat != null) {
                Weapon myWeapon = closestThreat.flying ? this.unit.getAirWeapon() : this.unit.getGroundWeapon();
                double hisAirWeaponRange = closestThreat.airRange;
                Position kitePos = UtilMicro.kiteAway(this.unit, new TreeSet<UnitInfo>(Collections.singleton(closestThreat)));
                if ((double)myWeapon.maxRange() > hisAirWeaponRange && bestDist > hisAirWeaponRange) {
                    if (myWeapon.cooldown() != 0) {
                        if (kitePos != null) {
                            UtilMicro.move(this.unit, kitePos);
                            return false;
                        }
                    } else if (harassed != null && this.unitInfo.getDistance(harassed) <= myWeapon.maxRange()) {
                        UtilMicro.attack(this.unitInfo, harassed);
                    } else {
                        UtilMicro.attack(this.unitInfo, closestThreat);
                    }
                    return false;
                }
                if (kitePos != null) {
                    UtilMicro.move(this.unit, kitePos);
                    return false;
                }
            }
            if (harassed != null) {
                UtilMicro.attack(this.unitInfo, harassed);
                return false;
            }
            UnitInfo target = Util.getRangedTarget(this.unitInfo, mainTargets);
            if (target != null) {
                UtilMicro.attack(this.unitInfo, target);
                return false;
            }
            if (attack != null) {
                if (attack.getDistance(this.myUnit.getPosition()) >= 160) {
                    UtilMicro.move(this.unit, attack);
                } else {
                    UtilMicro.attack(this.unit, attack);
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("Exception WraithAgent");
            e.printStackTrace();
            return false;
        }
    }

    private Position getBestBaseToHarass() {
        return Util.chooseAttackPosition(this.unit.getPosition(), true);
    }

    private UnitInfo chooseHarassTarget(Set<UnitInfo> mainTargets) {
        UnitInfo chosen = null;
        double maxScore = Double.MIN_VALUE;
        for (UnitInfo u : mainTargets) {
            double dist = this.unitInfo.getDistance(u);
            double score = u.unitType.isWorker() ? 5.0 : (double)(u.unitType == UnitType.Zerg_Overlord ? 8 : 1);
            WeaponType weapon = Util.getWeapon(this.unitInfo, u);
            score *= dist <= (double)weapon.maxRange() ? 1.4 : 0.9;
            score *= (double)u.unitType.maxHitPoints() / (double)u.health;
            if (chosen != null && !(maxScore < score)) continue;
            chosen = u;
            maxScore = score;
        }
        return chosen;
    }

    public boolean equals(Object o) {
        if (o == this.unit) {
            return true;
        }
        if (!(o instanceof WraithAgent)) {
            return false;
        }
        WraithAgent wraith = (WraithAgent)o;
        return this.unit.equals(wraith.unit);
    }

    public int hashCode() {
        return Objects.hash(this.unit.getId());
    }

    @Override
    public int compareTo(Unit v1) {
        return this.unit.getId() - v1.getId();
    }
}

