/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Agents;

import bwem.Area;
import bwem.Base;
import ecgberht.Agents.Agent;
import ecgberht.BuildingMap;
import ecgberht.Ecgberht;
import ecgberht.IntelligenceAgency;
import ecgberht.Simulation.SimInfo;
import ecgberht.UnitInfo;
import ecgberht.Util.ColorUtil;
import ecgberht.Util.Util;
import ecgberht.Util.UtilMicro;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bk.ass.path.Result;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Drone;
import org.openbw.bwapi4j.unit.Marine;
import org.openbw.bwapi4j.unit.SCV;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Zergling;

public class WorkerScoutAgent
extends Agent {
    private SCV unit;
    private int currentVertex;
    private List<Position> enemyBaseBorders = new ArrayList<Position>();
    private Base enemyBase;
    private Status status = Status.IDLE;
    private int enemyNaturalIndex = -1;
    private Building disrupter = null;
    private Building proxier = null;
    private boolean stoppedDisrupting = false;
    private boolean finishedDisrupting = false;
    private SimInfo mySim;
    private List<TilePosition> validTiles = new ArrayList<TilePosition>();
    private boolean removedIndex = false;
    private boolean ableToProxy = false;
    private TilePosition proxyTile = null;

    public WorkerScoutAgent(Unit unit, Base enemyBase) {
        super(unit);
        this.unit = (SCV)unit;
        this.enemyBase = enemyBase;
        this.canProxyInThisMap();
    }

    private void canProxyInThisMap() {
        Area enemyArea = this.enemyBase.getArea();
        Set<TilePosition> tilesArea = Ecgberht.getGs().map.getTilesArea(enemyArea);
        if (tilesArea == null) {
            return;
        }
        Result path = Ecgberht.getGs().silentCartographer.getWalkablePath(this.enemyBase.getLocation().toWalkPosition(), Ecgberht.getGs().enemyNaturalBase.getLocation().toWalkPosition());
        for (TilePosition t : tilesArea) {
            if (!Ecgberht.getGs().map.tileBuildable(t, UnitType.Terran_Factory) || t.getDistance(Util.getUnitCenterPosition(this.enemyBase.getLocation().toPosition(), UnitType.Zerg_Hatchery).toTilePosition()) <= 13.0 || this.enemyBase.getGeysers().stream().anyMatch(u -> t.getDistance(u.getCenter().toTilePosition()) <= 9.0) || path.path.stream().anyMatch(u -> t.getDistance(new WalkPosition(u.x, u.y).toTilePosition()) <= 10.0)) continue;
            this.validTiles.add(t);
        }
        if (this.validTiles.isEmpty()) {
            return;
        }
        double bestDist = 0.0;
        for (TilePosition p : this.validTiles) {
            double dist = p.getDistance(this.enemyBase.getLocation());
            if (!(dist > bestDist)) continue;
            bestDist = dist;
            this.proxyTile = p;
        }
        if (this.proxyTile != null) {
            this.ableToProxy = true;
        }
    }

    @Override
    public boolean runAgent() {
        if (this.unit == null || !this.unit.exists() || this.unitInfo == null || !Ecgberht.getGs().firstScout) {
            if (this.disrupter != null) {
                Ecgberht.getGs().disrupterBuilding = this.disrupter;
            }
            Ecgberht.getGs().firstScout = false;
            if (Ecgberht.getGs().proxyBuilding != null && !Ecgberht.getGs().proxyBuilding.isCompleted()) {
                Ecgberht.getGs().proxyBuilding.cancelConstruction();
            }
            return true;
        }
        if (this.status == Status.EXPLORE && Ecgberht.getGs().getStrat().proxy && this.mySim.allies.stream().anyMatch(u -> u.unit instanceof Marine)) {
            Ecgberht.getGs().myArmy.add(this.unitInfo);
            Ecgberht.getGs().firstScout = false;
            if (Ecgberht.getGs().proxyBuilding != null && !Ecgberht.getGs().proxyBuilding.isCompleted()) {
                Ecgberht.getGs().proxyBuilding.cancelConstruction();
            }
            return true;
        }
        if (this.enemyBaseBorders.isEmpty()) {
            this.updateBorders();
        }
        this.mySim = Ecgberht.getGs().sim.getSimulation(this.unitInfo, SimInfo.SimType.GROUND);
        if (this.enemyNaturalIndex != -1 && (IntelligenceAgency.getEnemyStrat() == IntelligenceAgency.EnemyStrats.EarlyPool || IntelligenceAgency.getEnemyStrat() == IntelligenceAgency.EnemyStrats.ZealotRush || Ecgberht.getGs().learningManager.isNaughty() || Ecgberht.getGs().basicCombatUnitsDetected(this.mySim.enemies) || IntelligenceAgency.getNumEnemyBases(Ecgberht.getGs().getIH().enemy()) > 1)) {
            this.enemyBaseBorders.remove(this.enemyNaturalIndex);
            this.enemyNaturalIndex = -1;
            this.removedIndex = true;
        }
        this.status = this.chooseNewStatus();
        this.cancelDisrupter();
        switch (this.status) {
            case EXPLORE: {
                this.followPerimeter();
                break;
            }
            case DISRUPTING: {
                this.disrupt();
                break;
            }
            case PROXYING: {
                this.proxy();
            }
        }
        if (this.disrupter != null) {
            Ecgberht.getGs().getGame().getMapDrawer().drawTextMap(this.disrupter.getPosition().add(new Position(0, -16)), ColorUtil.formatText("BM!", (byte)4));
        }
        return false;
    }

    private void cancelDisrupter() {
        if (this.stoppedDisrupting && this.disrupter != null && this.disrupter.getHitPoints() <= 20) {
            this.disrupter.cancelConstruction();
            this.disrupter = null;
        }
    }

    private void proxy() {
        if (this.proxier == null) {
            if (this.unit.getBuildUnit() != null) {
                this.proxier = (Building)this.unit.getBuildUnit();
                return;
            }
            if (this.unit.getOrder() != Order.PlaceBuilding) {
                if (this.proxyTile.getDistance(this.unitInfo.tileposition) <= 3.0) {
                    this.unit.build(this.proxyTile, UnitType.Terran_Factory);
                } else {
                    UtilMicro.move(this.unit, this.proxyTile.toPosition());
                }
            }
        }
    }

    private void disrupt() {
        if (this.disrupter == null) {
            if (this.unit.getBuildUnit() != null) {
                this.disrupter = (Building)this.unit.getBuildUnit();
                return;
            }
            if (this.unit.getOrder() != Order.PlaceBuilding) {
                this.unit.build(Ecgberht.getGs().enemyNaturalBase.getLocation(), UnitType.Terran_Engineering_Bay);
            }
        } else if (this.disrupter.getRemainingBuildTime() <= 25) {
            this.unit.haltConstruction();
            this.finishedDisrupting = true;
            this.stoppedDisrupting = true;
            this.removedIndex = true;
        } else if (!this.stoppedDisrupting) {
            if (this.mySim.enemies.stream().anyMatch(u -> this.unitInfo.getDistance((UnitInfo)u) <= 128)) {
                if (this.mySim.enemies.stream().anyMatch(u -> u.unit instanceof Zergling)) {
                    this.unit.haltConstruction();
                    this.stoppedDisrupting = true;
                    if (!this.removedIndex) {
                        this.enemyBaseBorders.remove(this.enemyNaturalIndex);
                        this.enemyNaturalIndex = -1;
                        this.removedIndex = true;
                    }
                    return;
                }
                if (this.mySim.enemies.size() == 1) {
                    UnitInfo closest = this.mySim.enemies.iterator().next();
                    Area enemyArea = Ecgberht.getGs().bwem.getMap().getArea(closest.tileposition);
                    if (closest.unit instanceof Drone && enemyArea != null && enemyArea.equals(Ecgberht.getGs().enemyNaturalArea) && this.mySim.lose) {
                        this.unit.haltConstruction();
                        this.stoppedDisrupting = true;
                        if (!this.removedIndex) {
                            this.enemyBaseBorders.remove(this.enemyNaturalIndex);
                            this.enemyNaturalIndex = -1;
                            this.removedIndex = true;
                        }
                    }
                }
            }
        } else if (this.mySim.enemies.isEmpty() && this.disrupter != null && !this.finishedDisrupting) {
            this.unit.resumeBuilding(this.disrupter);
        } else if (!(this.mySim.enemies.isEmpty() || !this.unitInfo.attackers.isEmpty() && this.mySim.lose)) {
            UnitInfo target = Util.getRangedTarget(this.unitInfo, this.mySim.enemies);
            if (target != null) {
                UtilMicro.attack(this.unitInfo, target);
            } else if (this.disrupter != null && !this.finishedDisrupting) {
                this.unit.resumeBuilding(this.disrupter);
            }
        }
        if (this.disrupter != null && !this.finishedDisrupting) {
            this.unit.resumeBuilding(this.disrupter);
        }
    }

    private Status chooseNewStatus() {
        if (this.status == Status.DISRUPTING) {
            if (this.finishedDisrupting || this.stoppedDisrupting && !this.unitInfo.attackers.isEmpty() && this.mySim.lose) {
                return Status.EXPLORE;
            }
            return Status.DISRUPTING;
        }
        if (this.status == Status.PROXYING) {
            if (this.proxyTile == null) {
                this.ableToProxy = false;
            } else if (this.proxier != null && this.proxier.isCompleted()) {
                this.ableToProxy = false;
                Ecgberht.getGs().proxyBuilding = this.proxier;
            } else {
                double dist = this.unitInfo.tileposition.getDistance(this.proxyTile);
                if (dist <= 3.0 && !this.unitInfo.attackers.isEmpty() && this.proxier != null && this.proxier.isBeingConstructed()) {
                    this.unit.haltConstruction();
                    this.ableToProxy = false;
                    this.proxier.cancelConstruction();
                    this.proxier = null;
                    return Status.EXPLORE;
                }
                return Status.PROXYING;
            }
        }
        if (this.finishedDisrupting) {
            return Status.EXPLORE;
        }
        String strat = Ecgberht.getGs().getStrat().name;
        if (Ecgberht.getGs().luckyDraw >= 0.7 && this.ableToProxy && strat.equals("TwoPortWraith") && !Ecgberht.getGs().learningManager.isNaughty() && !Ecgberht.getGs().MBs.isEmpty() && !Ecgberht.getGs().refineriesAssigned.isEmpty()) {
            return Status.PROXYING;
        }
        if (Ecgberht.getGs().luckyDraw >= 0.35 || strat.equals("BioGreedyFE") || strat.equals("MechGreedyFE") || strat.equals("BioMechGreedyFE") || strat.equals("ProxyBBS") || strat.equals("ProxyEightRax") || Ecgberht.getGs().learningManager.isNaughty()) {
            return Status.EXPLORE;
        }
        if (Ecgberht.getGs().enemyRace != Race.Zerg || this.stoppedDisrupting || this.finishedDisrupting) {
            return Status.EXPLORE;
        }
        if (IntelligenceAgency.getNumEnemyBases(Ecgberht.getGs().getIH().enemy()) == 1 && this.currentVertex == this.enemyNaturalIndex) {
            return Status.DISRUPTING;
        }
        return Status.EXPLORE;
    }

    private Position getNextPosition() {
        if (this.currentVertex == -1) {
            int closestPolygonIndex = this.getClosestVertexIndex();
            if (closestPolygonIndex == -1) {
                return Ecgberht.getGs().getPlayer().getStartLocation().toPosition();
            }
            this.currentVertex = closestPolygonIndex;
            return this.enemyBaseBorders.get(closestPolygonIndex);
        }
        if (this.currentVertex == this.enemyNaturalIndex && Ecgberht.getGs().getGame().getBWMap().isVisible(Ecgberht.getGs().enemyNaturalBase.getLocation())) {
            this.currentVertex = (this.currentVertex + 1) % this.enemyBaseBorders.size();
            return this.enemyBaseBorders.get(this.currentVertex);
        }
        double distanceFromCurrentVertex = this.enemyBaseBorders.get(this.currentVertex).getDistance(this.unit.getPosition());
        while (distanceFromCurrentVertex < 128.0) {
            this.currentVertex = (this.currentVertex + 1) % this.enemyBaseBorders.size();
            distanceFromCurrentVertex = this.enemyBaseBorders.get(this.currentVertex).getDistance(this.unit.getPosition());
        }
        return this.enemyBaseBorders.get(this.currentVertex);
    }

    private int getClosestVertexIndex() {
        int chosen = -1;
        double distMax = Double.MAX_VALUE;
        for (int ii = 0; ii < this.enemyBaseBorders.size(); ++ii) {
            double dist = this.enemyBaseBorders.get(ii).getDistance(this.unit.getPosition());
            if (!(dist < distMax)) continue;
            chosen = ii;
            distMax = dist;
        }
        return chosen;
    }

    private void followPerimeter() {
        UtilMicro.move(this.unit, this.getNextPosition());
    }

    private void updateBorders() {
        Area enemyRegion = this.enemyBase.getArea();
        if (enemyRegion == null) {
            return;
        }
        Position enemyCenter = this.enemyBase.getLocation().toPosition().add(new Position(64, 48));
        ArrayList closestTobase = new ArrayList(BuildingMap.tilesArea.get(enemyRegion));
        ArrayList<Position> unsortedVertices = new ArrayList<Position>();
        for (TilePosition tp : closestTobase) {
            if (Ecgberht.getGs().bwem.getMap().getArea(tp) != enemyRegion) continue;
            TilePosition right = new TilePosition(tp.getX() + 1, tp.getY());
            TilePosition bottom = new TilePosition(tp.getX(), tp.getY() + 1);
            TilePosition left = new TilePosition(tp.getX() - 1, tp.getY());
            TilePosition up = new TilePosition(tp.getX(), tp.getY() - 1);
            boolean edge = !Ecgberht.getGs().getGame().getBWMap().isValidPosition(right) || Ecgberht.getGs().bwem.getMap().getArea(right) != enemyRegion || !Ecgberht.getGs().getGame().getBWMap().isBuildable(right) || !Ecgberht.getGs().getGame().getBWMap().isValidPosition(bottom) || Ecgberht.getGs().bwem.getMap().getArea(bottom) != enemyRegion || !Ecgberht.getGs().getGame().getBWMap().isBuildable(bottom) || !Ecgberht.getGs().getGame().getBWMap().isValidPosition(left) || Ecgberht.getGs().bwem.getMap().getArea(left) != enemyRegion || !Ecgberht.getGs().getGame().getBWMap().isBuildable(left) || !Ecgberht.getGs().getGame().getBWMap().isValidPosition(up) || Ecgberht.getGs().bwem.getMap().getArea(up) != enemyRegion || !Ecgberht.getGs().getGame().getBWMap().isBuildable(up);
            if (!edge || !Ecgberht.getGs().getGame().getBWMap().isBuildable(tp)) continue;
            Position vertex = tp.toPosition().add(new Position(16, 16));
            double dist = enemyCenter.getDistance(vertex);
            if (dist > 368.0) {
                double pullBy = Math.min(dist - 368.0, 120.0);
                if (vertex.getX() == enemyCenter.getX()) {
                    vertex = vertex.add(new Position(0, vertex.getY() > enemyCenter.getY() ? (int)(-pullBy) : (int)pullBy));
                } else {
                    double m = (double)(enemyCenter.getY() - vertex.getY()) / (double)(enemyCenter.getX() - vertex.getX());
                    double x = (double)vertex.getX() + (vertex.getX() > enemyCenter.getX() ? -1.0 : 1.0) * pullBy / Math.sqrt(1.0 + m * m);
                    double y = m * (x - (double)vertex.getX()) + (double)vertex.getY();
                    vertex = new Position((int)x, (int)y);
                }
            }
            if (!Ecgberht.getGs().getGame().getBWMap().isValidPosition(vertex) || !Ecgberht.getGs().getGame().getBWMap().isWalkable(vertex.toWalkPosition())) continue;
            unsortedVertices.add(vertex);
        }
        ArrayList<Position> sortedVertices = new ArrayList<Position>();
        Position current = (Position)unsortedVertices.get(0);
        this.enemyBaseBorders.add(current);
        unsortedVertices.remove(current);
        while (!unsortedVertices.isEmpty()) {
            double bestDist = 1000000.0;
            Position bestPos = null;
            for (Position pos : unsortedVertices) {
                double dist = pos.getDistance(current);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
                bestPos = pos;
            }
            current = bestPos;
            sortedVertices.add(sortedVertices.size(), bestPos);
            unsortedVertices.remove(bestPos);
        }
        int distanceThreshold = 100;
        while (true) {
            int maxFarthest = 0;
            int maxFarthestStart = 0;
            int maxFarthestEnd = 0;
            for (int i = 0; i < sortedVertices.size(); ++i) {
                int farthest = 0;
                int farthestIndex = 0;
                for (int j = 1; j < sortedVertices.size() / 2; ++j) {
                    int jindex = (i + j) % sortedVertices.size();
                    if (((Position)sortedVertices.get(i)).getDistance((Position)sortedVertices.get(jindex)) >= distanceThreshold) continue;
                    farthest = j;
                    farthestIndex = jindex;
                }
                if (farthest <= maxFarthest) continue;
                maxFarthest = farthest;
                maxFarthestStart = i;
                maxFarthestEnd = farthestIndex;
            }
            if (maxFarthest < 4) break;
            ArrayList temp = new ArrayList();
            int s = maxFarthestEnd;
            while (s != maxFarthestStart) {
                temp.add(temp.size(), sortedVertices.get(s));
                s = (s + 1) % sortedVertices.size();
            }
            sortedVertices = temp;
        }
        this.enemyBaseBorders = sortedVertices;
        this.currentVertex = 0;
        if (!Ecgberht.getGs().learningManager.isNaughty()) {
            Base enemyNatural = Ecgberht.getGs().enemyNaturalBase;
            if (enemyNatural != null) {
                Position enemyNaturalPos = enemyNatural.getLocation().toPosition();
                int index = -1;
                double distMax = Double.MAX_VALUE;
                for (int ii = 0; ii < this.enemyBaseBorders.size(); ++ii) {
                    double dist = Util.getGroundDistance(this.enemyBaseBorders.get(ii), enemyNaturalPos);
                    if (index != -1 && !(dist < distMax)) continue;
                    index = ii;
                    distMax = dist;
                }
                this.enemyBaseBorders.add(index, enemyNaturalPos);
                this.enemyNaturalIndex = index;
            }
        } else {
            this.enemyNaturalIndex = -1;
            this.removedIndex = true;
        }
    }

    @Override
    public String statusToString() {
        if (this.status == Status.EXPLORE) {
            return "Exploring";
        }
        if (this.status == Status.DISRUPTING) {
            return "Disrupting";
        }
        if (this.status == Status.PROXYING) {
            return "Proxying";
        }
        if (this.status == Status.IDLE) {
            return "Idle";
        }
        return "None";
    }

    static enum Status {
        EXPLORE,
        DISRUPTING,
        IDLE,
        PROXYING;

    }
}

