/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Agents;

import bwem.Base;
import ecgberht.Agents.Agent;
import ecgberht.Ecgberht;
import ecgberht.Simulation.SimInfo;
import ecgberht.UnitInfo;
import ecgberht.Util.MutablePair;
import ecgberht.Util.Util;
import ecgberht.Util.UtilMicro;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.Bunker;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Vulture;

public class VultureAgent
extends Agent
implements Comparable<Unit> {
    public Vulture unit;
    private int mines = 3;
    private UnitType type = UnitType.Terran_Vulture;
    private int lastPatrolFrame = 0;
    private SimInfo mySim;

    public VultureAgent(Unit unit) {
        super(unit);
        this.unit = (Vulture)unit;
    }

    public void placeMine(Position pos) {
        if (this.mines > 0) {
            this.unit.spiderMine(pos);
        }
    }

    @Override
    public boolean runAgent() {
        try {
            if (!this.unit.exists() || this.unitInfo == null) {
                return true;
            }
            if (this.unit.getHitPoints() <= 20) {
                MutablePair<Base, Unit> cc = Ecgberht.getGs().mainCC;
                if (cc != null && cc.second != null) {
                    Position ccPos = ((Unit)cc.second).getPosition();
                    if (Ecgberht.getGs().getGame().getBWMap().isValidPosition(ccPos)) {
                        this.unit.move(ccPos);
                        Ecgberht.getGs().myArmy.add(this.unitInfo);
                        return true;
                    }
                }
                this.unit.move(Ecgberht.getGs().getPlayer().getStartLocation().toPosition());
                Ecgberht.getGs().myArmy.add(this.unitInfo);
                return true;
            }
            this.mySim = Ecgberht.getGs().sim.getSimulation(this.unitInfo, SimInfo.SimType.GROUND);
            this.actualFrame = Ecgberht.getGs().frameCount;
            this.frameLastOrder = this.unit.getLastCommandFrame();
            if (this.frameLastOrder == this.actualFrame) {
                return false;
            }
            this.getNewStatus();
            if (this.status != Agent.Status.COMBAT && this.status != Agent.Status.PATROL) {
                this.attackUnit = null;
            }
            if (!(this.status != Agent.Status.ATTACK && this.status != Agent.Status.IDLE || !this.unit.isIdle() && this.unit.getOrder() != Order.PlayerGuard)) {
                Position pos = Util.chooseAttackPosition(this.unit.getPosition(), false);
                if (pos == null || !Ecgberht.getGs().getGame().getBWMap().isValidPosition(pos)) {
                    return false;
                }
                UtilMicro.move(this.unit, pos);
                this.status = Agent.Status.ATTACK;
                return false;
            }
            switch (this.status) {
                case ATTACK: {
                    this.attack();
                    break;
                }
                case COMBAT: {
                    this.combat();
                    break;
                }
                case KITE: {
                    this.kite();
                    break;
                }
                case RETREAT: {
                    this.retreat();
                    break;
                }
                case PATROL: {
                    this.patrol();
                }
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("Exception VultureAgent");
            e.printStackTrace();
            return false;
        }
    }

    private void patrol() {
        Position pos;
        if (this.unit.getOrder() == Order.Patrol) {
            return;
        }
        if (this.attackUnit != null && this.unit.getOrder() != Order.Patrol && (pos = Util.choosePatrolPositionVulture(this.unit, this.attackUnit)) != null && Ecgberht.getGs().getGame().getBWMap().isValidPosition(pos)) {
            this.unit.patrol(pos);
            this.attackUnit = null;
            this.lastPatrolFrame = this.actualFrame;
            return;
        }
        this.attackUnit = null;
    }

    private void combat() {
        UnitInfo toAttack = Util.getRangedTarget(this.unitInfo, this.mySim.enemies);
        if (toAttack != null) {
            if (this.attackUnit != null && this.attackUnit.equals(toAttack)) {
                return;
            }
            UtilMicro.attack(this.unitInfo, toAttack);
            this.attackUnit = toAttack;
        }
    }

    private Position selectNewAttack() {
        Position p = Util.chooseAttackPosition(this.myUnit.getPosition(), false);
        if (p != null && Ecgberht.getGs().getGame().getBWMap().isValidPosition(p)) {
            return p;
        }
        if (Ecgberht.getGs().enemyMainBase != null) {
            return Ecgberht.getGs().enemyMainBase.getLocation().toPosition();
        }
        return null;
    }

    private UnitInfo getUnitToAttack(Set<UnitInfo> enemies) {
        UnitInfo chosen = null;
        double distB = Double.MAX_VALUE;
        for (UnitInfo u : enemies) {
            if (u.flying || u.unit.isCloaked()) continue;
            double distA = this.unitInfo.getDistance(u);
            if (chosen != null && !(distA < distB)) continue;
            chosen = u;
            distB = distA;
        }
        return chosen;
    }

    private void retreat() {
        Position CC = Ecgberht.getGs().getNearestCC(this.myUnit.getPosition(), true);
        if (CC != null) {
            UtilMicro.move(this.unit, CC);
        } else {
            UtilMicro.move(this.unit, Ecgberht.getGs().getPlayer().getStartLocation().toPosition());
        }
        this.attackPos = null;
        this.attackUnit = null;
    }

    private void getNewStatus() {
        if (this.mySim.enemies.isEmpty()) {
            this.status = Agent.Status.ATTACK;
        } else {
            boolean meleeOnly = this.checkOnlyMelees();
            if (!meleeOnly && Ecgberht.getGs().sim.getSimulation((UnitInfo)this.unitInfo, (SimInfo.SimType)SimInfo.SimType.GROUND).lose) {
                this.status = Util.isInOurBases(this.unitInfo) ? Agent.Status.KITE : Agent.Status.RETREAT;
                return;
            }
            if (this.status == Agent.Status.PATROL && this.actualFrame - this.lastPatrolFrame > 5) {
                this.status = Agent.Status.COMBAT;
                return;
            }
            int cd = this.unit.getGroundWeapon().cooldown();
            UnitInfo closestAttacker = Util.getClosestUnit(this.unitInfo, this.mySim.enemies, true);
            if (closestAttacker != null && (cd != 0 || (double)this.unitInfo.getDistance(closestAttacker) < this.unitInfo.groundRange * 0.6)) {
                this.status = Agent.Status.KITE;
                return;
            }
            if ((this.status == Agent.Status.COMBAT || this.status == Agent.Status.ATTACK) && cd > 0) {
                Position predictedPosition;
                if (this.attackUnit != null && (predictedPosition = UtilMicro.predictUnitPosition(this.attackUnit, 2)) != null && Ecgberht.getGs().getGame().getBWMap().isValidPosition(predictedPosition)) {
                    double distCurrent;
                    double distPredicted = this.unit.getDistance(predictedPosition);
                    if (distPredicted > (distCurrent = (double)this.unitInfo.getDistance(this.attackUnit))) {
                        this.status = Agent.Status.COMBAT;
                        return;
                    }
                    this.attackUnit = null;
                    this.attackPos = null;
                    this.status = Agent.Status.KITE;
                    return;
                }
                if (this.mySim.enemies.isEmpty()) {
                    this.status = Agent.Status.ATTACK;
                    return;
                }
                this.status = Agent.Status.COMBAT;
                return;
            }
            if (this.status == Agent.Status.KITE) {
                UnitInfo closest = this.getUnitToAttack(this.mySim.enemies);
                if (closest != null) {
                    double dist = this.unitInfo.getDistance(closest);
                    double speed = this.type.topSpeed();
                    double timeToEnter = 0.0;
                    if (speed > 1.0E-5) {
                        timeToEnter = Math.max(0.0, dist - (double)this.type.groundWeapon().maxRange()) / speed;
                    }
                    if (timeToEnter >= (double)cd) {
                        this.status = Agent.Status.PATROL;
                        this.attackUnit = closest;
                        return;
                    }
                } else {
                    this.status = Agent.Status.ATTACK;
                    return;
                }
                if (cd == 0) {
                    this.status = Agent.Status.COMBAT;
                }
            }
        }
    }

    private boolean checkOnlyMelees() {
        for (UnitInfo e : this.mySim.enemies) {
            int weaponRange = (int)e.groundRange;
            if (weaponRange <= 32 && !(e.unit instanceof Bunker) || e.unit.getDistance(this.unit) >= weaponRange) continue;
            return false;
        }
        return true;
    }

    private void kite() {
        Optional<UnitInfo> closestUnit = this.mySim.enemies.stream().min(Comparator.comparing(u -> this.unitInfo.getDistance((UnitInfo)u)));
        Position kite = closestUnit.map(unit1 -> UtilMicro.kiteAwayAlt(this.unit.getPosition(), unit1.position)).orElse(null);
        if (!(kite != null && Ecgberht.getGs().getGame().getBWMap().isValidPosition(kite) || (kite = UtilMicro.kiteAway(this.unit, this.mySim.enemies)) != null && Ecgberht.getGs().getGame().getBWMap().isValidPosition(kite))) {
            this.retreat();
            return;
        }
        UtilMicro.move(this.unit, kite);
    }

    private void attack() {
        if (this.unit.isAttackFrame()) {
            return;
        }
        this.attackPos = this.selectNewAttack();
        if (this.attackPos == null || !Ecgberht.getGs().bw.getBWMap().isValidPosition(this.attackPos)) {
            this.attackUnit = null;
            this.attackPos = null;
            return;
        }
        UtilMicro.attack(this.unit, this.attackPos);
        this.attackUnit = null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VultureAgent)) {
            return false;
        }
        VultureAgent vulture = (VultureAgent)o;
        return this.unit.equals(vulture.unit);
    }

    public int hashCode() {
        return Objects.hash(this.unit.getId());
    }

    @Override
    public int compareTo(Unit v1) {
        return this.unit.getId() - v1.getId();
    }
}

