/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Agents;

import ecgberht.Agents.Agent;
import ecgberht.Ecgberht;
import ecgberht.Simulation.SimInfo;
import ecgberht.Squad;
import ecgberht.UnitInfo;
import ecgberht.Util.Util;
import ecgberht.Util.UtilMicro;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.Egg;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.Organic;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.ScienceVessel;
import org.openbw.bwapi4j.unit.Scourge;
import org.openbw.bwapi4j.unit.SiegeTank;
import org.openbw.bwapi4j.unit.SporeColony;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Worker;

public class VesselAgent
extends Agent
implements Comparable<Unit> {
    public ScienceVessel unit;
    public Squad follow = null;
    private Status status = Status.IDLE;
    private Set<UnitInfo> airAttackers = new TreeSet<UnitInfo>();
    private Position center;
    private Unit target;
    private Unit oldTarget;

    public VesselAgent(Unit unit) {
        super(unit);
        this.unit = (ScienceVessel)unit;
    }

    @Override
    public String statusToString() {
        if (this.status == Status.IRRADIATE) {
            return "Irradiate";
        }
        if (this.status == Status.DMATRIX) {
            return "DefenseMatrix";
        }
        if (this.status == Status.KITE) {
            return "Kite";
        }
        if (this.status == Status.FOLLOW) {
            return "Follow";
        }
        if (this.status == Status.RETREAT) {
            return "Retreat";
        }
        if (this.status == Status.IDLE) {
            return "Idle";
        }
        if (this.status == Status.HOVER) {
            return "Hover";
        }
        if (this.status == Status.EMP) {
            return "EMP";
        }
        return "None";
    }

    @Override
    public boolean runAgent() {
        try {
            if (!this.unit.exists() || this.unitInfo == null) {
                return true;
            }
            this.actualFrame = Ecgberht.getGs().frameCount;
            this.frameLastOrder = this.unit.getLastCommandFrame();
            this.airAttackers.clear();
            if (this.frameLastOrder == this.actualFrame) {
                return false;
            }
            this.follow = this.chooseVesselSquad();
            if (this.follow == null) {
                this.status = Status.RETREAT;
                this.retreat();
                return false;
            }
            switch (this.status) {
                case DMATRIX: {
                    if (this.unitInfo.energy > TechType.Defensive_Matrix.energyCost()) break;
                    Ecgberht.getGs().wizard.irradiatedUnits.remove(this.unit);
                    this.status = Status.IDLE;
                    this.target = null;
                    this.oldTarget = null;
                    break;
                }
                case IRRADIATE: {
                    if (this.unitInfo.energy > TechType.Irradiate.energyCost()) break;
                    Ecgberht.getGs().wizard.irradiatedUnits.remove(this.unit);
                    this.status = Status.IDLE;
                    this.target = null;
                    this.oldTarget = null;
                    break;
                }
                case EMP: {
                    if (this.unitInfo.energy > TechType.EMP_Shockwave.energyCost()) break;
                    Ecgberht.getGs().wizard.EMPedUnits.remove(this.unit);
                    this.status = Status.IDLE;
                    this.target = null;
                    this.oldTarget = null;
                }
            }
            this.center = this.follow.getSquadCenter();
            this.getNewStatus();
            switch (this.status) {
                case IRRADIATE: {
                    this.irradiate();
                    break;
                }
                case DMATRIX: {
                    this.dMatrix();
                    break;
                }
                case KITE: {
                    this.kite();
                    break;
                }
                case FOLLOW: {
                    this.followSquad();
                    break;
                }
                case RETREAT: {
                    this.retreat();
                    break;
                }
                case HOVER: {
                    this.hover();
                    break;
                }
                case EMP: {
                    this.emp();
                }
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("Exception VesselAgent");
            e.printStackTrace();
            return false;
        }
    }

    private void hover() {
        Position attack = this.follow.attack;
        if (attack == null || !Ecgberht.getGs().getGame().getBWMap().isValidPosition(attack)) {
            return;
        }
        UtilMicro.move(this.unit, attack);
    }

    private Squad chooseVesselSquad() {
        Squad chosen = null;
        double scoreMax = Double.MIN_VALUE;
        for (Squad s : Ecgberht.getGs().sqManager.squads.values()) {
            double dist = this.unitInfo.getDistance(s.getSquadCenter());
            double score = -Math.pow(s.members.size(), 3.0) / dist;
            if (chosen != null && !(score > scoreMax)) continue;
            chosen = s;
            scoreMax = dist;
        }
        return chosen;
    }

    private void emp() {
        if (this.unitInfo.currentOrder == Order.CastEMPShockwave) {
            if (this.target != null && this.oldTarget != null && !this.target.equals(this.oldTarget)) {
                UtilMicro.emp(this.unit, this.target.getPosition());
                Ecgberht.getGs().wizard.addEMPed(this.unit, (PlayerUnit)this.target);
                this.oldTarget = this.target;
            }
        } else if (this.target != null && this.target.exists() && this.unitInfo.currentOrder != Order.CastEMPShockwave) {
            UtilMicro.emp(this.unit, this.target.getPosition());
            Ecgberht.getGs().wizard.addEMPed(this.unit, (PlayerUnit)this.target);
            this.oldTarget = this.target;
        }
        if (!(this.oldTarget == null || this.oldTarget.exists() && ((PlayerUnit)this.oldTarget).getShields() > 1)) {
            this.oldTarget = null;
        }
        if (!(this.target == null || this.target.exists() && ((PlayerUnit)this.target).getShields() > 1)) {
            this.target = null;
        }
    }

    private void irradiate() {
        if (this.unitInfo.currentOrder == Order.CastIrradiate) {
            if (this.target != null && this.oldTarget != null && !this.target.equals(this.oldTarget)) {
                UtilMicro.irradiate(this.unit, (PlayerUnit)this.target);
                Ecgberht.getGs().wizard.addIrradiated(this.unit, (PlayerUnit)this.target);
                this.oldTarget = this.target;
            }
        } else if (this.target != null && this.target.exists() && this.unitInfo.currentOrder != Order.CastIrradiate) {
            UtilMicro.irradiate(this.unit, (PlayerUnit)this.target);
            Ecgberht.getGs().wizard.addIrradiated(this.unit, (PlayerUnit)this.target);
            this.oldTarget = this.target;
        }
        if (this.oldTarget != null && (!this.oldTarget.exists() || ((PlayerUnit)this.oldTarget).isIrradiated())) {
            this.oldTarget = null;
        }
        if (this.target != null && (!this.target.exists() || ((PlayerUnit)this.target).isIrradiated())) {
            this.target = null;
        }
    }

    private void dMatrix() {
        if (this.unitInfo.currentOrder == Order.CastDefensiveMatrix) {
            if (this.target != null && this.oldTarget != null && !this.target.equals(this.oldTarget)) {
                UtilMicro.defenseMatrix(this.unit, (MobileUnit)this.target);
                Ecgberht.getGs().wizard.addDefenseMatrixed(this.unit, (MobileUnit)this.target);
                this.oldTarget = this.target;
            }
        } else if (this.target != null && this.target.exists() && this.unitInfo.currentOrder != Order.CastDefensiveMatrix) {
            UtilMicro.defenseMatrix(this.unit, (MobileUnit)this.target);
            Ecgberht.getGs().wizard.addDefenseMatrixed(this.unit, (MobileUnit)this.target);
            this.oldTarget = this.target;
        }
        if (this.oldTarget != null && (!this.oldTarget.exists() || ((MobileUnit)this.oldTarget).isDefenseMatrixed())) {
            this.oldTarget = null;
        }
        if (this.target != null && (!this.target.exists() || ((MobileUnit)this.target).isDefenseMatrixed())) {
            this.target = null;
        }
    }

    private void kite() {
        Position kite;
        Set<UnitInfo> airThreats = this.airAttackers.stream().filter(u -> u.unitType == UnitType.Zerg_Scourge || u.unitType == UnitType.Zerg_Spore_Colony).collect(Collectors.toSet());
        if (!airThreats.isEmpty() && (kite = UtilMicro.kiteAway(this.unit, airThreats)) != null) {
            UtilMicro.move(this.unit, kite);
            return;
        }
        kite = UtilMicro.kiteAway(this.unit, this.airAttackers);
        if (kite == null || !Ecgberht.getGs().getGame().getBWMap().isValidPosition(kite)) {
            return;
        }
        UtilMicro.move(this.unit, kite);
    }

    private void followSquad() {
        if (this.center == null || !Ecgberht.getGs().getGame().getBWMap().isValidPosition(this.center)) {
            return;
        }
        UtilMicro.move(this.unit, this.center);
    }

    private void getNewStatus() {
        SimInfo mySimAir = Ecgberht.getGs().sim.getSimulation(this.unitInfo, SimInfo.SimType.AIR);
        SimInfo mySimMix = Ecgberht.getGs().sim.getSimulation(this.unitInfo, SimInfo.SimType.MIX);
        boolean chasenByScourge = false;
        boolean sporeColony = false;
        double maxScore = 0.0;
        PlayerUnit chosen = null;
        if (Ecgberht.getGs().enemyRace == Race.Zerg && !mySimAir.enemies.isEmpty()) {
            for (UnitInfo unitInfo : mySimAir.enemies) {
                if (unitInfo.unit instanceof Scourge && unitInfo.target.equals(this.unit)) {
                    chasenByScourge = true;
                } else if (unitInfo.unit instanceof SporeColony && (double)this.unitInfo.getDistance(unitInfo) < unitInfo.airRange * 1.2) {
                    sporeColony = true;
                }
                if (!chasenByScourge || !sporeColony) continue;
                break;
            }
        }
        if (!mySimMix.enemies.isEmpty()) {
            TreeSet<UnitInfo> irradiateTargets = new TreeSet<UnitInfo>(mySimMix.enemies);
            for (UnitInfo unitInfo : mySimMix.allies) {
                if (!(unitInfo.unit instanceof SiegeTank)) continue;
                irradiateTargets.add(unitInfo);
            }
            if (this.follow != null && !irradiateTargets.isEmpty() && Ecgberht.getGs().getPlayer().hasResearched(TechType.Irradiate) && this.unit.getEnergy() >= TechType.Irradiate.energyCost() && this.follow.status != Squad.Status.IDLE) {
                for (UnitInfo unitInfo : irradiateTargets) {
                    if (!unitInfo.visible || unitInfo.unit instanceof Building || unitInfo.unit instanceof Egg || !(unitInfo.unit instanceof Organic) && !(unitInfo.unit instanceof SiegeTank) || unitInfo.unit instanceof MobileUnit && (unitInfo.unit.isIrradiated() || ((MobileUnit)unitInfo.unit).isStasised()) || Ecgberht.getGs().wizard.isUnitIrradiated(unitInfo.unit)) continue;
                    double score = 1.0;
                    int closeUnits = 0;
                    for (UnitInfo close : irradiateTargets) {
                        if (unitInfo.equals(close) || !(close.unit instanceof Organic) || close.burrowed || unitInfo.getDistance(close) > 32) continue;
                        ++closeUnits;
                    }
                    if (unitInfo.unitType == UnitType.Zerg_Lurker) {
                        score = unitInfo.burrowed ? 20.0 : 18.0;
                    } else if (unitInfo.unitType == UnitType.Zerg_Mutalisk) {
                        score = 8.0;
                    } else if (unitInfo.unitType == UnitType.Zerg_Hydralisk) {
                        score = 5.0;
                    } else if (unitInfo.unitType == UnitType.Zerg_Zergling) {
                        score = 2.0;
                    }
                    score *= unitInfo.percentHealth;
                    double multiplier = unitInfo.unit instanceof SiegeTank ? 3.75 : (unitInfo.unitType == UnitType.Zerg_Lurker ? 2.5 : (unitInfo.unitType == UnitType.Zerg_Mutalisk ? 2.0 : 1.0));
                    score += multiplier * (double)closeUnits;
                    if (chosen != null && !(score > maxScore)) continue;
                    chosen = unitInfo.unit;
                    maxScore = score;
                }
                if (maxScore >= 5.0) {
                    this.status = Status.IRRADIATE;
                    this.target = chosen;
                    return;
                }
            }
            chosen = null;
            maxScore = 0.0;
            TreeSet<UnitInfo> treeSet = new TreeSet<UnitInfo>(mySimMix.enemies);
            if (this.follow != null && !treeSet.isEmpty() && Ecgberht.getGs().getPlayer().hasResearched(TechType.EMP_Shockwave) && this.unit.getEnergy() >= TechType.EMP_Shockwave.energyCost() && this.follow.status != Squad.Status.IDLE) {
                for (UnitInfo u : treeSet) {
                    if (!u.visible || u.unit instanceof Building || u.unit instanceof Worker || u.unit instanceof MobileUnit && (u.unit.isIrradiated() || ((MobileUnit)u.unit).isStasised()) || Ecgberht.getGs().wizard.isUnitEMPed(u.unit)) continue;
                    double score = 1.0;
                    double closeUnits = 0.0;
                    for (UnitInfo close : treeSet) {
                        if (u.equals(close) || close.lastPosition.getDistance(u.lastPosition) > WeaponType.EMP_Shockwave.innerSplashRadius()) continue;
                        closeUnits += (double)close.shields * 0.6;
                    }
                    if (u.unitType == UnitType.Protoss_High_Templar) {
                        score = 10.0;
                    } else if (u.unitType == UnitType.Protoss_Arbiter) {
                        score = 7.0;
                    } else if (u.unitType == UnitType.Protoss_Archon || u.unitType == UnitType.Protoss_Dark_Archon) {
                        score = 5.0;
                    }
                    score *= u.percentShield;
                    double multiplier = u.unitType == UnitType.Protoss_High_Templar ? 6.0 : 1.0;
                    score += multiplier * closeUnits;
                    if (chosen != null && !(score > maxScore)) continue;
                    chosen = u.unit;
                    maxScore = score;
                }
                if (maxScore >= 6.0) {
                    this.status = Status.EMP;
                    this.target = chosen;
                    return;
                }
            }
            chosen = null;
            maxScore = 0.0;
        }
        if (!mySimMix.allies.isEmpty()) {
            TreeSet<UnitInfo> matrixTargets = new TreeSet<UnitInfo>(mySimMix.allies);
            if (this.follow != null && !matrixTargets.isEmpty() && this.unit.getEnergy() >= TechType.Defensive_Matrix.energyCost() && this.follow.status != Squad.Status.IDLE) {
                for (UnitInfo unitInfo : matrixTargets) {
                    if (!(unitInfo.unit instanceof MobileUnit) || Ecgberht.getGs().wizard.isDefenseMatrixed((MobileUnit)unitInfo.unit)) continue;
                    double score = 1.0;
                    if (!unitInfo.unit.isUnderAttack() || ((MobileUnit)unitInfo.unit).isDefenseMatrixed()) continue;
                    if (unitInfo.unitType.isMechanical()) {
                        score = 8.0;
                    }
                    if (unitInfo.unitType == UnitType.Terran_Marine || unitInfo.unitType == UnitType.Terran_Firebat) {
                        score = 3.0;
                    }
                    if (unitInfo.unitType == UnitType.Terran_SCV || unitInfo.unitType == UnitType.Terran_Medic) {
                        score = 1.0;
                    }
                    score *= (double)unitInfo.unitType.maxHitPoints() / (double)unitInfo.health;
                    if (chosen != null && !(score > maxScore)) continue;
                    chosen = unitInfo.unit;
                    maxScore = score;
                }
                if (maxScore >= 2.0) {
                    this.status = Status.DMATRIX;
                    this.target = chosen;
                    return;
                }
            }
        }
        if ((this.status == Status.IRRADIATE || this.status == Status.DMATRIX || this.status == Status.EMP) && this.target != null) {
            return;
        }
        if (!mySimAir.enemies.isEmpty()) {
            if (this.unit.isUnderAttack() || chasenByScourge || sporeColony) {
                this.status = Status.KITE;
            } else if (Util.broodWarDistance(this.unit.getPosition(), this.center) >= 100.0) {
                this.status = Status.FOLLOW;
            } else if (mySimAir.lose) {
                this.status = Status.KITE;
            }
        } else {
            this.status = mySimMix.lose ? Status.RETREAT : (Util.broodWarDistance(this.unit.getPosition(), this.center) >= 200.0 ? Status.FOLLOW : Status.HOVER);
        }
    }

    private void retreat() {
        Position CC = Ecgberht.getGs().getNearestCC(this.myUnit.getPosition(), true);
        if (CC != null) {
            ((MobileUnit)this.myUnit).move(CC);
        } else {
            ((MobileUnit)this.myUnit).move(Ecgberht.getGs().getPlayer().getStartLocation().toPosition());
        }
        this.attackPos = null;
        this.attackUnit = null;
    }

    public boolean equals(Object o) {
        if (o == this.unit) {
            return true;
        }
        if (!(o instanceof VesselAgent)) {
            return false;
        }
        VesselAgent vessel = (VesselAgent)o;
        return this.unit.equals(vessel.unit);
    }

    public int hashCode() {
        return Objects.hash(this.unit);
    }

    @Override
    public int compareTo(Unit v1) {
        return this.unit.getId() - v1.getId();
    }

    static enum Status {
        DMATRIX,
        KITE,
        FOLLOW,
        IDLE,
        RETREAT,
        IRRADIATE,
        HOVER,
        EMP;

    }
}

