/*
 * Decompiled with CFR 0.152.
 */
package ecgberht.Agents;

import ecgberht.Agents.Agent;
import ecgberht.Ecgberht;
import ecgberht.Util.Util;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Order;
import org.openbw.bwapi4j.unit.Dropship;
import org.openbw.bwapi4j.unit.Loadable;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.Worker;

public class DropShipAgent
extends Agent
implements Comparable<Unit> {
    public Dropship unit;
    Status status = Status.IDLE;
    private Set<Unit> airAttackers = new TreeSet<Unit>();
    private Set<Unit> cargoLoaded = new TreeSet<Unit>();
    private Set<Unit> cargoWanted = new TreeSet<Unit>();
    private Position target;
    private Unit pickingUp;

    public DropShipAgent(Unit unit) {
        super(unit);
        this.unit = (Dropship)unit;
    }

    @Override
    public String statusToString() {
        switch (this.status) {
            case PICKING: {
                return "PICKING";
            }
            case MOVING: {
                return "MOVING";
            }
            case DROP: {
                return "DROP";
            }
            case RETREAT: {
                return "RETREAT";
            }
            case IDLE: {
                return "IDLE";
            }
        }
        return "None";
    }

    public void setCargo(Set<Unit> cargo) {
        this.cargoWanted = cargo;
        for (Unit u : this.cargoWanted) {
            if (u instanceof Worker && (((Worker)u).isCarryingMinerals() || ((Worker)u).isCarryingGas())) {
                ((Worker)u).returnCargo();
                ((MobileUnit)u).rightClick(this.unit, true);
                continue;
            }
            ((MobileUnit)u).rightClick(this.unit, false);
        }
    }

    public void setTarget(Position target) {
        this.target = target;
    }

    private void checkLoaded() {
        if (this.pickingUp == null) {
            return;
        }
        Loadable transport = ((MobileUnit)this.pickingUp).getTransport();
        if (transport != null && transport.equals(this.unit)) {
            this.cargoLoaded.add(this.pickingUp);
            this.cargoWanted.remove(this.pickingUp);
            this.pickingUp = null;
        }
    }

    private void checkUnloaded() {
        for (Unit u : this.cargoLoaded) {
            Loadable transport = ((MobileUnit)u).getTransport();
            if (transport != null) continue;
            this.cargoLoaded.remove(u);
            break;
        }
    }

    @Override
    public boolean runAgent() {
        try {
            if (!this.unit.exists() || this.unitInfo == null) {
                return true;
            }
            this.actualFrame = Ecgberht.getGs().frameCount;
            this.frameLastOrder = this.unit.getLastCommandFrame();
            if (this.actualFrame == this.frameLastOrder) {
                return false;
            }
            this.airAttackers.clear();
            if (this.frameLastOrder == this.actualFrame) {
                return false;
            }
            this.status = this.getNewStatus();
            switch (this.status) {
                case PICKING: {
                    this.picking();
                    break;
                }
                case MOVING: {
                    this.moving();
                    break;
                }
                case DROP: {
                    this.drop();
                    break;
                }
                case RETREAT: {
                    this.retreat();
                    break;
                }
                case IDLE: {
                    this.idle();
                }
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("Exception DropShipAgent");
            e.printStackTrace();
            return false;
        }
    }

    private void drop() {
        if (this.target == null) {
            return;
        }
        this.checkUnloaded();
        if (this.cargoLoaded.isEmpty()) {
            return;
        }
        if (this.unit.getOrder() == Order.MoveUnload || this.unit.getOrder() == Order.Unload) {
            return;
        }
        this.unit.unloadAll(this.target);
    }

    private void moving() {
        if (this.target == null) {
            return;
        }
        if (this.unit.getTargetPosition() != null && this.unit.getTargetPosition().equals(this.target)) {
            return;
        }
        this.unit.move(this.target);
    }

    private void picking() {
        if (this.cargoWanted.isEmpty()) {
            return;
        }
        if (this.pickingUp == null) {
            double distB = Double.MAX_VALUE;
            for (Unit u : this.cargoWanted) {
                double distA = Util.broodWarDistance(this.unit.getPosition(), u.getPosition());
                if (this.pickingUp != null && !(distA < distB)) continue;
                this.pickingUp = u;
                distB = distA;
            }
            if (this.pickingUp != null) {
                this.unit.load((MobileUnit)this.pickingUp);
            }
        } else {
            if (this.unit.getOrderTarget() != null && this.unit.getOrderTarget().equals(this.pickingUp)) {
                return;
            }
            this.checkLoaded();
        }
    }

    private void idle() {
    }

    protected void retreat() {
        Position CC = Ecgberht.getGs().getNearestCC(this.myUnit.getPosition(), false);
        this.target = CC != null ? CC : Ecgberht.getGs().getPlayer().getStartLocation().toPosition();
        ((MobileUnit)this.myUnit).move(this.target);
    }

    private Status getNewStatus() {
        if (this.status == Status.IDLE) {
            if (!this.cargoWanted.isEmpty()) {
                return Status.PICKING;
            }
            if (!this.cargoLoaded.isEmpty() && this.target != null) {
                return Status.MOVING;
            }
        }
        if (this.status == Status.PICKING) {
            if (!this.cargoWanted.isEmpty()) {
                return Status.PICKING;
            }
            if (!this.cargoLoaded.isEmpty() && this.target != null) {
                return Status.MOVING;
            }
        }
        if (this.status == Status.MOVING) {
            if (this.target == null) {
                return Status.IDLE;
            }
            if (Util.broodWarDistance(this.unit.getPosition(), this.target) < 200.0) {
                return Status.DROP;
            }
            return Status.MOVING;
        }
        if (this.status == Status.DROP) {
            if (this.cargoLoaded.isEmpty()) {
                return Status.RETREAT;
            }
            return Status.DROP;
        }
        if (this.status == Status.RETREAT) {
            if (this.target != null && Util.broodWarDistance(this.unit.getPosition(), this.target) <= 64.0) {
                return Status.IDLE;
            }
            return Status.RETREAT;
        }
        return Status.IDLE;
    }

    public boolean equals(Object o) {
        if (o == this.unit) {
            return true;
        }
        if (!(o instanceof DropShipAgent)) {
            return false;
        }
        DropShipAgent dropship = (DropShipAgent)o;
        return this.unit.equals(dropship.unit);
    }

    public int hashCode() {
        return Objects.hash(this.unit);
    }

    @Override
    public int compareTo(Unit v1) {
        return this.unit.getId() - v1.getId();
    }

    static enum Status {
        PICKING,
        MOVING,
        DROP,
        RETREAT,
        IDLE;

    }
}

