/*
 * Decompiled with CFR 0.152.
 */
package bwem.util;

import java.util.Collections;
import java.util.List;

public final class Utils {
    private Utils() {
    }

    public static int queenWiseNorm(int dx, int dy) {
        return Math.max(Math.abs(dx), Math.abs(dy));
    }

    public static int squaredNorm(int dx, int dy) {
        return dx * dx + dy * dy;
    }

    public static double norm(int dx, int dy) {
        return Math.sqrt(Utils.squaredNorm(dx, dy));
    }

    public static int scalarProduct(int ax, int ay, int bx, int by) {
        return ax * bx + ay * by;
    }

    private static boolean getLineIntersection(double p0X, double p0Y, double p1X, double p1Y, double p2X, double p2Y, double p3X, double p3Y) {
        double s1X = p1X - p0X;
        double s1Y = p1Y - p0Y;
        double s2X = p3X - p2X;
        double s2Y = p3Y - p2Y;
        double s = (-s1Y * (p0X - p2X) + s1X * (p0Y - p2Y)) / (-s2X * s1Y + s1X * s2Y);
        double t = (s2X * (p0Y - p2Y) - s2Y * (p0X - p2X)) / (-s2X * s1Y + s1X * s2Y);
        return s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0;
    }

    public static boolean intersect(int ax, int ay, int bx, int by, int cx, int cy, int dx, int dy) {
        return Utils.getLineIntersection(ax, ay, bx, by, cx, cy, dx, dy);
    }

    public static <T> void fastErase(List<T> list, int index) {
        if (0 > index || index >= list.size()) {
            throw new IllegalArgumentException("index: " + index);
        }
        Collections.swap(list, index, list.size() - 1);
        list.remove(list.size() - 1);
    }
}

