/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.Altitude;
import bwem.AreaId;
import bwem.BWMap;
import bwem.Base;
import bwem.ChokePoint;
import bwem.Geyser;
import bwem.Mineral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;

public abstract class Area {
    final Map<Area, List<ChokePoint>> chokePointsByArea = new HashMap<Area, List<ChokePoint>>();
    final List<Area> accessibleNeighbors = new ArrayList<Area>();
    final List<ChokePoint> chokePoints = new ArrayList<ChokePoint>();
    final List<Mineral> minerals = new ArrayList<Mineral>();
    final List<Geyser> geysers = new ArrayList<Geyser>();
    final List<Base> bases = new ArrayList<Base>();
    private final AreaId id;
    private final WalkPosition walkPositionWithHighestAltitude;
    private final int miniTileCount;
    int groupId = 0;
    Altitude highestAltitude;
    TilePosition topLeft = new TilePosition(Integer.MAX_VALUE, Integer.MAX_VALUE);
    TilePosition bottomRight = new TilePosition(Integer.MIN_VALUE, Integer.MIN_VALUE);
    int tileCount = 0;
    int buildableTileCount = 0;
    int highGroundTileCount = 0;
    int veryHighGroundTileCount = 0;
    protected final BWMap map;

    Area(AreaId areaId, WalkPosition top, int miniTileCount, BWMap map) {
        this.id = areaId;
        this.walkPositionWithHighestAltitude = top;
        this.miniTileCount = miniTileCount;
        this.map = map;
    }

    public AreaId getId() {
        return this.id;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public TilePosition getTopLeft() {
        return this.topLeft;
    }

    public TilePosition getBottomRight() {
        return this.bottomRight;
    }

    public TilePosition getBoundingBoxSize() {
        return this.bottomRight.subtract(this.topLeft).add(new TilePosition(1, 1));
    }

    public WalkPosition getWalkPositionWithHighestAltitude() {
        return this.walkPositionWithHighestAltitude;
    }

    public WalkPosition getTop() {
        return this.getWalkPositionWithHighestAltitude();
    }

    public Altitude getHighestAltitude() {
        return this.highestAltitude;
    }

    public int getSize() {
        return this.miniTileCount;
    }

    public int getLowGroundPercentage() {
        int lowGroundTileCount = this.tileCount - this.highGroundTileCount - this.veryHighGroundTileCount;
        return lowGroundTileCount * 100 / this.tileCount;
    }

    public int getHighGroundPercentage() {
        return this.highGroundTileCount * 100 / this.tileCount;
    }

    public int getVeryHighGroundPercentage() {
        return this.veryHighGroundTileCount * 100 / this.tileCount;
    }

    public List<ChokePoint> getChokePoints() {
        return this.chokePoints;
    }

    public List<ChokePoint> getChokePoints(Area area) {
        List<ChokePoint> ret = this.chokePointsByArea.get(area);
        if (ret == null) {
            this.map.asserter.throwIllegalStateException("");
        }
        return ret;
    }

    public Map<Area, List<ChokePoint>> getChokePointsByArea() {
        return this.chokePointsByArea;
    }

    public List<Area> getAccessibleNeighbors() {
        return this.accessibleNeighbors;
    }

    public boolean isAccessibleFrom(Area area) {
        return this.groupId == area.getGroupId();
    }

    public List<Mineral> getMinerals() {
        return this.minerals;
    }

    public List<Geyser> getGeysers() {
        return this.geysers;
    }

    public List<Base> getBases() {
        return this.bases;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Area)) {
            return false;
        }
        Area that = (Area)object;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

