/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Position;
import bwapi.PositionOrUnit;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitCommandType;
import bwapi.UnitType;
import bwapi.UpgradeType;

public class UnitCommand {
    private Unit unit;
    private UnitCommandType unitCommandType;
    private Unit target;
    private int x;
    private int y;
    private int extra;

    public static native UnitCommand attack(Unit var0, PositionOrUnit var1);

    public static native UnitCommand attack(Unit var0, PositionOrUnit var1, boolean var2);

    public static native UnitCommand build(Unit var0, TilePosition var1, UnitType var2);

    public static native UnitCommand buildAddon(Unit var0, UnitType var1);

    public static native UnitCommand train(Unit var0, UnitType var1);

    public static native UnitCommand morph(Unit var0, UnitType var1);

    public static native UnitCommand research(Unit var0, TechType var1);

    public static native UnitCommand upgrade(Unit var0, UpgradeType var1);

    public static native UnitCommand setRallyPoint(Unit var0, PositionOrUnit var1);

    public static native UnitCommand move(Unit var0, Position var1);

    public static native UnitCommand move(Unit var0, Position var1, boolean var2);

    public static native UnitCommand patrol(Unit var0, Position var1);

    public static native UnitCommand patrol(Unit var0, Position var1, boolean var2);

    public static native UnitCommand holdPosition(Unit var0);

    public static native UnitCommand holdPosition(Unit var0, boolean var1);

    public static native UnitCommand stop(Unit var0);

    public static native UnitCommand stop(Unit var0, boolean var1);

    public static native UnitCommand follow(Unit var0, Unit var1);

    public static native UnitCommand follow(Unit var0, Unit var1, boolean var2);

    public static native UnitCommand gather(Unit var0, Unit var1);

    public static native UnitCommand gather(Unit var0, Unit var1, boolean var2);

    public static native UnitCommand returnCargo(Unit var0);

    public static native UnitCommand returnCargo(Unit var0, boolean var1);

    public static native UnitCommand repair(Unit var0, Unit var1);

    public static native UnitCommand repair(Unit var0, Unit var1, boolean var2);

    public static native UnitCommand burrow(Unit var0);

    public static native UnitCommand unburrow(Unit var0);

    public static native UnitCommand cloak(Unit var0);

    public static native UnitCommand decloak(Unit var0);

    public static native UnitCommand siege(Unit var0);

    public static native UnitCommand unsiege(Unit var0);

    public static native UnitCommand lift(Unit var0);

    public static native UnitCommand land(Unit var0, TilePosition var1);

    public static native UnitCommand load(Unit var0, Unit var1);

    public static native UnitCommand load(Unit var0, Unit var1, boolean var2);

    public static native UnitCommand unload(Unit var0, Unit var1);

    public static native UnitCommand unloadAll(Unit var0);

    public static native UnitCommand unloadAll(Unit var0, boolean var1);

    public static native UnitCommand unloadAll(Unit var0, Position var1);

    public static native UnitCommand unloadAll(Unit var0, Position var1, boolean var2);

    public static native UnitCommand rightClick(Unit var0, PositionOrUnit var1);

    public static native UnitCommand rightClick(Unit var0, PositionOrUnit var1, boolean var2);

    public static native UnitCommand haltConstruction(Unit var0);

    public static native UnitCommand cancelConstruction(Unit var0);

    public static native UnitCommand cancelAddon(Unit var0);

    public static native UnitCommand cancelTrain(Unit var0);

    public static native UnitCommand cancelTrain(Unit var0, int var1);

    public static native UnitCommand cancelMorph(Unit var0);

    public static native UnitCommand cancelResearch(Unit var0);

    public static native UnitCommand cancelUpgrade(Unit var0);

    public static native UnitCommand useTech(Unit var0, TechType var1);

    public static native UnitCommand useTech(Unit var0, TechType var1, PositionOrUnit var2);

    public static native UnitCommand placeCOP(Unit var0, TilePosition var1);

    private UnitCommand(Unit unit, UnitCommandType unitCommandType, Unit unit2, int n, int n2, int n3) {
        this.unit = unit;
        this.unitCommandType = unitCommandType;
        this.target = unit2;
        this.x = n;
        this.y = n2;
        this.extra = n3;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public UnitCommandType getUnitCommandType() {
        return this.unitCommandType;
    }

    public Unit getTarget() {
        return this.target;
    }

    public int getSlot() {
        if (this.unitCommandType == UnitCommandType.None) {
            return this.extra;
        }
        return -1;
    }

    public Position getTargetPosition() {
        if (this.unitCommandType == UnitCommandType.Build || this.unitCommandType == UnitCommandType.Land || this.unitCommandType == UnitCommandType.Place_COP) {
            return new Position(this.x * 32, this.y * 32);
        }
        return new Position(this.x, this.y);
    }

    public TilePosition getTargetTilePosition() {
        if (this.unitCommandType == UnitCommandType.Build || this.unitCommandType == UnitCommandType.Land || this.unitCommandType == UnitCommandType.Place_COP) {
            return new TilePosition(this.x, this.y);
        }
        return new TilePosition(this.x / 32, this.y / 32);
    }

    public boolean isQueued() {
        if (this.unitCommandType == UnitCommandType.Attack_Move || this.unitCommandType == UnitCommandType.Attack_Unit || this.unitCommandType == UnitCommandType.Move || this.unitCommandType == UnitCommandType.Patrol || this.unitCommandType == UnitCommandType.Hold_Position || this.unitCommandType == UnitCommandType.Stop || this.unitCommandType == UnitCommandType.Follow || this.unitCommandType == UnitCommandType.Gather || this.unitCommandType == UnitCommandType.Return_Cargo || this.unitCommandType == UnitCommandType.Repair || this.unitCommandType == UnitCommandType.Load || this.unitCommandType == UnitCommandType.Unload_All || this.unitCommandType == UnitCommandType.Unload_All_Position || this.unitCommandType == UnitCommandType.Right_Click_Position || this.unitCommandType == UnitCommandType.Right_Click_Unit) {
            return this.extra != 0;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnitCommand)) {
            return false;
        }
        UnitCommand unitCommand = (UnitCommand)object;
        if (this.extra != unitCommand.extra) {
            return false;
        }
        if (this.x != unitCommand.x) {
            return false;
        }
        if (this.y != unitCommand.y) {
            return false;
        }
        if (this.target != null ? !this.target.equals(unitCommand.target) : unitCommand.target != null) {
            return false;
        }
        if (this.unit != null ? !this.unit.equals(unitCommand.unit) : unitCommand.unit != null) {
            return false;
        }
        return !(this.unitCommandType != null ? !this.unitCommandType.equals(unitCommand.unitCommandType) : unitCommand.unitCommandType != null);
    }

    public int hashCode() {
        int n = this.unit != null ? this.unit.hashCode() : 0;
        n = 31 * n + (this.unitCommandType != null ? this.unitCommandType.hashCode() : 0);
        n = 31 * n + (this.target != null ? this.target.hashCode() : 0);
        n = 31 * n + this.x;
        n = 31 * n + this.y;
        n = 31 * n + this.extra;
        return n;
    }
}

