package Information.Grids.Combat

import Information.Grids.ArrayTypes.AbstractGridVersionedValue
import Lifecycle.With
import Mathematics.Shapes.Ring

class GridEnemyVulnerabilityGround extends AbstractGridVersionedValue[Int] {

  override val defaultValue = 0
  override protected var values: Array[Int] = Array.fill(length)(defaultValue)

  val rangeMax = 11
  val framesAhead = 12

  override def onUpdate(): Unit = {
    return
    //if ( ! With.units.existsOurs(Protoss.Reaver)) return
    for (unit <- With.units.enemy) {
      if (unit.likelyStillThere && (unit.canAttack || unit.unitClass.spells.nonEmpty) && unit.battle.nonEmpty) {
        val tileUnit = unit.projectFrames(framesAhead).tileIncluding
        for (d <- 1 to rangeMax) {
          for (point <- Ring.points(d)) {
            val tile = tileUnit.add(point)
            if (tile.valid) {
              val range = rangeMax - d
              set(tile, if (isSet(tile)) Math.max(range, get(tile)) else range)
            }
          }
        }
      }
    }
  }
}
