class UnitPotential
{
public:
	UnitPotential(Unit unit,Position position) : unit_(unit), position_(position) {}
	void add_potential(UnitType type,Position position,double potential,int max_distance);
	void add_potential(Unit unit,double potential,int max_distance);
	void add_potential(Position position,double potential,int max_distance);
	void add_potential(Position position,double potential);
	void repel_units(const std::vector<Unit>& units,Unit skip_unit = nullptr);
	void repel_storms();
	void repel_detectors(double potential);
	void repel_emps();
	void repel_buildings();
	void repel_terrain();
	void kite_units(const std::vector<Unit>& units,Unit skip_unit = nullptr);
	
	Unit unit() const { return unit_; }
	UnitType type() const { return unit_->getType(); }
	Position position() const { return position_; }
	double value() const { return value_; }
	bool empty() const { return value_ == 0.0; }
private:
	Unit unit_;
	Position position_;
	double value_ = 0.0;
};

bool unit_potential(Unit unit,std::function<void(UnitPotential&)> function);
