#pragma once

class Strategy : public Singleton<Strategy>
{
public:
	// PvZ
	static constexpr char* kPvZ_SairDt = "PvZ_sairdt";
	static constexpr char* kPvZ_1012Gate = "PvZ_10/12gate";
	static constexpr char* kPvZ_1BaseSpeedZeal = "PvZ_1basespeedzeal";
	static constexpr char* kPvZ_2BaseSpeedZeal = "PvZ_2basespeedzeal";
	static constexpr char* kPvZ_Bisu = "PvZ_bisu";
	static constexpr char* kPvZ_NeoBisu = "PvZ_neobisu";
	static constexpr char* kPvZ_4Gate2Archon = "PvZ_4gate2archon";
	static constexpr char* kPvZ_5GateGoon = "PvZ_5gategoon";
	static constexpr char* kPvZ_SairGoon = "PvZ_sairgoon";
	static constexpr char* kPvZ_Stove = "PvZ_stove";
	static constexpr char* kPvZ_99Gate = "PvZ_9/9gate";
	static constexpr char* kPvZ_99ProxyGate = "PvZ_9/9proxygate";
	
	// PvT
	static constexpr char* kPvT_NZCore = "PvT_nzcore";
	static constexpr char* kPvT_ZCore = "PvT_zcore";
	static constexpr char* kPvT_ZZCore = "PvT_zzcore";
	static constexpr char* kPvT_1012Gate = "PvT_10/12gate";
	static constexpr char* kPvT_2GateDt = "PvT_2gatedt";
	static constexpr char* kPvT_1GateDtExpo = "PvT_1gatedtexpo";
	static constexpr char* kPvT_1015Gate = "PvT_10/15gate";
	static constexpr char* kPvT_Bulldog = "PvT_bulldog";
	static constexpr char* kPvT_12Nexus = "PvT_12nexus";
	static constexpr char* kPvT_DtDrop = "PvT_dtdrop";
	static constexpr char* kPvT_Stove = "PvT_stove";
	static constexpr char* kPvT_99Gate = "PvT_9/9gate";
	static constexpr char* kPvT_99ProxyGate = "PvT_9/9proxygate";
	static constexpr char* kPvT_ProxyDt = "PvT_proxydt";
	
	// PvP
	static constexpr char* kPvP_NZCore = "PvP_nzcore";
	static constexpr char* kPvP_ZCore = "PvP_zcore";
	static constexpr char* kPvP_ZZCore = "PvP_zzcore";
	static constexpr char* kPvP_ZCoreZ = "PvP_zcorez";
	static constexpr char* kPvP_1012Gate = "PvP_10/12gate";
	static constexpr char* kPvP_2GateDt = "PvP_2gatedt";
	static constexpr char* kPvP_2GateDtExpo = "PvP_2gatedtexpo";
	static constexpr char* kPvP_3GateRobo = "PvP_3gaterobo";
	static constexpr char* kPvP_3GateSpeedZeal = "PvP_3gatespeedzeal";
	static constexpr char* kPvP_4GateGoon = "PvP_4gategoon";
	static constexpr char* kPvP_12Nexus = "PvP_12nexus";
	static constexpr char* kPvP_99Gate = "PvP_9/9gate";
	static constexpr char* kPvP_99ProxyGate = "PvP_9/9proxygate";
	
	// PvU
	static constexpr char* kPvU_NZCore = "PvU_nzcore";
	static constexpr char* kPvU_ZCore = "PvU_zcore";
	static constexpr char* kPvU_ZZCore = "PvU_zzcore";
	static constexpr char* kPvU_1012Gate = "PvU_10/12gate";
	static constexpr char* kPvU_99Gate = "PvU_9/9gate";
	static constexpr char* kPvU_99ProxyGate = "PvU_9/9proxygate";
	static constexpr char* kPvU_Flex = "PvU_flex";
	
	// Map specific
	static constexpr char* kPvZ_Plasma_Carriers = "PvZ_plasma_carriers";
	static constexpr char* kPvT_Plasma_Carriers = "PvT_plasma_carriers";
	static constexpr char* kPvP_Plasma_Carriers = "PvP_plasma_carriers";
	static constexpr char* kPvU_Plasma_Carriers = "PvU_plasma_carriers";
	static constexpr char* kPvZ_Plasma_99ProxyGate = "PvZ_plasma_9/9proxygate";
	static constexpr char* kPvT_Plasma_99ProxyGate = "PvT_plasma_9/9proxygate";
	static constexpr char* kPvP_Plasma_99ProxyGate = "PvP_plasma_9/9proxygate";
	static constexpr char* kPvU_Plasma_99ProxyGate = "PvU_plasma_9/9proxygate";
	
	static constexpr char* kMapHash_Plasma = "6f5295624a7e3887470f3f2e14727b1411321a67";
	static constexpr char* kMapHash_Hitchhiker = "69a3b6a5a3d4120e47408defd3ca44c954997948";
	
	static constexpr int kLateGameCarrierMaxAltitude = 384;
	static constexpr int kLateGameArbiterMinAltitude = 512;
	
	enum class Mode
	{
		Opening,
		DefendFastPool,
		DefendFastPoolFFE,
		DefendProxyGate,
		ReactiveFastExpand,
		RegularMidToEndGame
	};
	
	void pick_strategy();
	void apply_result(bool win);
	std::string mode() const;
	const std::string& opening() const { return opening_; }
	const bool late_game_carriers() const { return late_game_carriers_; }
	void frame();
	
private:
	Mode mode_ = Mode::Opening;
	std::string opening_;
	bool opening_subtype_set_ = false;
	bool opening_subtype_zealot_first_;
	bool opening_attack_started_ = false;
	bool opening_initial_zealots_done_ = false;
	bool opening_zealot_started_ = false;
	bool opening_scout_started_ = false;
	bool opening_setup_plasma_carriers_done_ = false;
	bool opening_setup_plasma_proxy_gate_done_ = false;
	TilePosition opening_proxy_location_ = TilePositions::Unknown;
	bool opening_PvZ_fast_expand_completed_ = false;
	bool opening_forge_fast_expand_positioned_ = false;
	bool opening_forge_fast_expand_positioned_successfully_ = false;
	bool opening_gateway_first_expand_positioned_successfully_ = false;
	int opening_variant_ = -1;
	bool opening_preventing_scouting_ = false;
	bool fast_pool_handled_ = false;
	bool proxy_gate_handled_ = false;
	
	int attack_minimum_ = 40;
	bool attacking_ = false;
	bool initial_dark_templar_attack_ = false;
	bool late_game_carriers_ = false;
	bool zerg_dragoon_strategy_ = false;
	
	void pick_opening();
	void pick_late_game_strategy();
	void opening_PvZ_SairDt();
	void opening_PvZ_1012Gate();
	void opening_PvZ_1BaseSpeedZeal();
	void opening_PvZ_2BaseSpeedZeal();
	void opening_PvZ_Bisu();
	void opening_PvZ_NeoBisu();
	void opening_PvZ_4Gate2Archon();
	void opening_PvZ_5GateGoon();
	void opening_PvZ_SairGoon();
	void opening_PvT_NZCore();
	void opening_PvT_ZCore();
	void opening_PvT_ZZCore();
	void opening_PvT_1012Gate();
	void opening_PvT_1GateDtExpo();
	void opening_PvT_1015Gate();
	void opening_PvT_Bulldog();
	void opening_PvT_12Nexus();
	void opening_PvT_DtDrop();
	void opening_PvT_ProxyDt();
	void opening_PvP_NZCore();
	void opening_PvP_ZCore();
	void opening_PvP_ZZCore();
	void opening_PvP_ZCoreZ();
	void opening_PvP_1012Gate();
	void opening_PvP_2GateDtExpo();
	void opening_PvP_3GateRobo();
	void opening_PvP_3GateSpeedZeal();
	void opening_PvP_4GateGoon();
	void opening_PvP_12Nexus();
	void opening_PvU_NZCore();
	void opening_PvU_ZCore();
	void opening_PvU_ZZCore();
	void opening_PvU_1012Gate();
	void opening_PvU_Flex();
	void opening_PvX_Stove();
	void opening_PvX_2GateDt();
	void opening_PvX_99Gate();
	void opening_PvX_99ProxyGate();
	void opening_PvX_plasma_carriers();
	void opening_PvX_plasma_99ProxyGate();
	void opening_build_units(UnitType unit_type,int count,bool stop_probe_production=true);
	void opening_prevent_scouting();
	void opening_PvT_DtDrop_tail();
	void opening_PvZ_fast_expand();
	void opening_PvZ_fast_expand_12pool();
	void opening_PvZ_fast_expand_12hatch();
	void opening_PvZ_fast_expand_overpool();
	void opening_PvZ_fast_expand_9pool();
	
	void mode_opening();
	void mode_defend_fast_pool();
	void mode_defend_fast_pool_ffe();
	void mode_defend_proxy_gate();
	void mode_reactive_fast_expand();
	void mode_regular_mid_to_end_game();
	
	void tech_tree();
	void observer_tree(bool important=false);
	bool observer_tree_done();
	void robotics_facility_tree();
	bool robotics_facility_tree_done();
	void templar_tree();
	bool templar_tree_done();
	void forge_updates();
	void arbiter_tree();
	bool arbiter_tree_done();
	void carrier_tree();
	bool carrier_tree_done();
	
	void update_train_distributions();
	void update_stargate_train_distribution();
	void update_robotics_facility_train_distribution();
	void update_gateway_train_distribution();
	void update_gateway_train_distribution(bool dragoon,bool high_templar,bool dark_templar);
	bool want_reavers();
	bool want_high_templars();
	bool is_defending_rush();
	bool is_opponent_army_too_large();
	bool dragoons_verus_zerg();
	bool need_more_anti_air();
	bool is_contained();
	bool dark_templars_without_mobile_detection();
	bool expect_lurkers();
	bool hydralisks_too_fast();
	int zerg_flyer_count();
	bool need_counter_carriers();
	void counter_carriers();
	bool counter_carriers_done();
	int counter_carriers_requested_dark_archon_count();
	int potential_dark_archon_count();
	void additional_production_buildings();
	void additional_gateways();
	
	void attack_check_condition();
	void apply_stage_positions();
	void attack_enemy();
	bool desperation_attack_condition();
};
