struct Result
{
	std::string timestamp;
	int start_positions;
	std::string map;
	std::string strategy;
	double duration;
	bool is_win;
	std::string opponent_strategy;
};

class ResultStore : public Singleton<ResultStore>
{
public:
	void init();
	std::string pick_strategy(std::initializer_list<std::string> strategies);
	void apply_result(const std::string& strategy,const std::string& opponent_strategy,bool win);
	void store();
	
private:
	static constexpr char* kComputerPlayerName = "Computer";
	
	struct StrategyRecord
	{
		int win_count = 0;
		int loss_count = 0;
		double score = 0.0;
		
		bool empty() { return win_count == 0 && loss_count == 0; }
		int count() { return win_count + loss_count; }
	};
	
	char ai_filename_[512];
	char read_filename_[512];
	char write_filename_[512];
	
	std::vector<Result> prepared_results_;
	std::vector<Result> results_;
	
	void init_filenames();
	void read_file();
	void read_prepared_results();
	void read_results();
	static void read_file(FILE *f,std::vector<Result>& results);
	static std::string pick_at_random(const std::vector<const std::string*>& strategies);
	
	static std::string determine_name();
	static int determine_start_positions();
	static std::string determine_map_name();
	static double determine_duration();
};
