#pragma once

struct TentativeStorm
{
	TentativeStorm() {}
	TentativeStorm(Unit unit,int expire_frame,Position position) : unit(unit), expire_frame(expire_frame), position(position) {}
	
	Unit unit;
	int expire_frame;
	Position position;
};

struct TentativeMindControl
{
	TentativeMindControl() {}
	TentativeMindControl(Unit unit,int expire_frame,Unit target) : unit(unit), expire_frame(expire_frame), target(target) {}
	
	Unit unit;
	int expire_frame;
	Unit target;
};

struct TentativeStasis
{
	TentativeStasis() {}
	TentativeStasis(Unit unit,int expire_frame,Position position) : unit(unit), expire_frame(expire_frame), position(position) {}
	
	Unit unit;
	int expire_frame;
	Position position;
};

enum class ShuttleCommand {
	Default = 0,
	LoadDarkTemplars = 1,
	DropInEnemyBase = 2
};

struct ShuttleState
{
	ShuttleCommand command = ShuttleCommand::Default;
	Position position = Positions::None;
};

struct CorsairTarget
{
	Position position;
	int expire_frame;
};

struct ObserverTarget
{
	bool scouting = true;
	Position position = Positions::None;
	int expire_frame;
};

class DragoonState
{
public:
	static constexpr int kDragoonAttackFrames = 6;
	
	void update(Unit unit);
	bool is_busy();
private:
	Unit unit_ = nullptr;
	int last_attack_start_frame_ = -1;
};

class UnstickState
{
public:
	void update(Unit unit);
	bool is_stuck();
private:
	Unit unit_ = nullptr;
	int stuck_since_ = -1;
	Position last_position_ = Positions::None;
};

class CombatState
{
public:
	CombatState(Unit unit) : unit_(unit) {}
	Unit unit() const { return unit_; }
	const Position& target_position() const { return target_position_; }
	void set_target_position(const Position& target_position) { target_position_ = target_position; }
	const Position& stage_position() const { return stage_position_; }
	void set_stage_position(const Position& stage_position) { stage_position_ = stage_position; }
	bool always_advance() const { return always_advance_; }
	void set_always_advance(bool always_advance) { always_advance_ = always_advance; }
private:
	Unit unit_;
	Position target_position_ = Positions::None;
	Position stage_position_ = Positions::None;
	bool always_advance_ = false;
	
	Unit shield_battery_ = nullptr;
	
	Unit shield_battery() const { return shield_battery_; }
	void set_shield_battery(Unit shield_battery) { shield_battery_ = shield_battery; }
	
	friend class MicroManager;
};

struct CombatUnitTarget
{
	static int constexpr kTargetUpdateFrames = 2;
	
	Unit unit = nullptr;
	int frame = -1;
	bool enable_attack = true;
	
	bool should_update_target(Unit combat_unit) const;
};

class MicroManager : public Singleton<MicroManager>
{
public:
	void prepare_combat();
	void apply_combat_orders();
	void draw();
	void perform_dark_templar_drop();
	
	std::map<Unit,CombatState>& combat_state() { return combat_state_; }
	int prevent_high_templar_from_archon_warp_count() const { return prevent_high_templar_from_archon_warp_count_; }
	void set_prevent_high_templar_from_archon_warp_count(int prevent_high_templar_from_archon_warp_count) { prevent_high_templar_from_archon_warp_count_ = prevent_high_templar_from_archon_warp_count; }
	bool force_archon_warp() const { return force_archon_warp_; }
	void set_force_archon_warp(bool force_archon_warp) { force_archon_warp_ = force_archon_warp; }
	int requested_dark_archon_count() const { return requested_dark_archon_count_; }
	void set_requested_dark_archon_count(int requested_dark_archon_count) { requested_dark_archon_count_ = requested_dark_archon_count; }
	
	std::vector<Position> list_existing_storm_positions();
	
	static bool bunker_runby_possible();
private:
	static constexpr int kStormThreshold = 5;
	static constexpr int kStormThresholdUnderAttack = 1;
	static constexpr int kStasisRadius = 48;
	static constexpr int kStasisThreshold = 5;
	static constexpr int kMedicHealRange = 2 * 32;
	static constexpr int kShieldBatteryRechargeRange = 4 * 32;
	static constexpr int kShieldBatterySeekRange = 10 * 32;
	
	std::map<Unit,CombatState> combat_state_;
	
	std::vector<Unit> all_enemy_units_;
	std::vector<Unit> harassable_enemy_units_;
	std::set<Unit> loading_units_;
	
	std::vector<Unit> combat_units_;
	std::vector<Unit> corsairs_;
	std::vector<Unit> observers_;
	std::vector<Unit> high_templars_;
	std::vector<Unit> dark_archons_;
	std::vector<Unit> shuttles_;
	std::vector<Unit> arbiters_;
	std::vector<Unit> scouts_;
	
	std::map<Unit,DragoonState> dragoon_state_;
	std::map<Unit,UnstickState> unstick_state_;
	std::vector<TentativeStorm> tentative_storms_;
	std::vector<TentativeMindControl> tentative_mind_controls_;
	std::vector<TentativeStasis> tentative_stasises_;
	std::map<Unit,ShuttleState> shuttle_state_;
	std::map<Unit,CorsairTarget> corsair_targets_;
	std::map<Unit,ObserverTarget> observer_targets_;
	std::map<Unit,CombatUnitTarget> combat_unit_targets_;
	int prevent_high_templar_from_archon_warp_count_ = -1;
	bool force_archon_warp_ = false;
	int requested_dark_archon_count_ = 0;
	bool scout_reached_base_ = false;
	
	std::set<Unit> units_near_base_;
	std::set<Unit> units_near_main_base_;
	std::set<Unit> ignore_when_attacking_;
	
	Unit run_by_bunker_ = nullptr;
	Position run_by_target_position_ = Positions::None;
	std::set<Unit> running_by_;
	std::set<Unit> desperados_;
	
	void update_units_lists();
	static int offense_distance_to_base(const EnemyCluster& cluster);
	static int offense_distance_to_base(const InformationUnit* enemy_unit);
	void update_units_near_base();
	void update_units_near_main_base();
	void update_ignore_when_attacking();
	void apply_shuttle_orders();
	void apply_combat_unit_orders();
	void apply_scout_orders();
	void apply_corsair_orders();
	void apply_observer_orders();
	void apply_arbiter_orders();
	void apply_high_templar_orders();
	void apply_dark_archon_orders();
	void expire_tentative_abilities();
	static int distance_to_base(const BWEM::Base *base,const InformationUnit* enemy_unit);
	int distance_to_proxy_pylon(const InformationUnit* enemy_unit);
	Position calculate_interception_position(Unit combat_unit,Unit enemy_unit);
	bool unit_in_safe_location(Unit unit);
	Position determine_first_observer_location(Unit special_unit);
	Position closest_sieged_tank(Position position);
	bool melee_unit_near_sieged_tank(Position tank_position);
	bool melee_unit_near_sieged_tank(Unit unit);
	bool load_closest_unit_of_type(Unit shuttle_unit,UnitType load_type,bool ignore_distance=false);
	Position pick_scout_location();
	void move_retreat(Unit unit,Position target_position);
	void move_with_blockade_breaking(Unit unit,Position target_position);
	bool recharge_at_shield_battery(Unit unit);
	bool recharge_at_shield_battery(Unit unit,Unit shield_battery_unit);
	Unit determine_nearby_sieged_tank(Unit combat_unit);
	Unit combat_unit_closest_to_target(Position target_position);
	Unit combat_unit_closest_to_special_unit(Unit special_unit);
	bool valid_target(Unit combat_unit,Unit enemy_unit);
	Unit select_enemy_unit_for_scout(Unit combat_unit,bool scout_reached_base);
	std::pair<Unit,bool> select_enemy_unit_for_combat_unit(Unit combat_unit);
	Unit select_enemy_unit_for_dark_templar(Unit combat_unit);
	bool safe_to_attack_by_dark_templar(Unit enemy_unit);
	Unit select_enemy_unit(Unit combat_unit,const std::vector<Unit>& enemy_units);
	static int target_tie_breaker(Unit combat_unit,Unit target_unit);
	static double calculate_kill_time(Unit combat_unit,Unit enemy_unit);
	static double calculate_incoming_dpf_sum(Unit combat_unit,Position position);
	static double calculate_incoming_dpf(Unit combat_unit,Position position,const InformationUnit& enemy_unit);
	static double calculate_incoming_dpf_for_medic(Unit combat_unit,Position position,const InformationUnit& ememy_unit);
	static bool is_suicidal_with_target(const InformationUnit& enemy_unit);
	static double calculate_chance_to_hit(Unit attacking_unit,Unit defending_unit);
	static double calculate_chance_to_hit(UnitType attacking_unit_type,Position attacking_unit_position,Position defending_unit_position);
	static double calculate_splash_factor(Unit attacking_unit,Unit defending_unit);
	static double calculate_splash_factor(UnitType attacking_unit_type,bool defending_unit_flying);
	static std::map<Unit,std::pair<int,FastPosition>> calculate_approach_distances_and_positions(Unit combat_unit,std::vector<Unit>& enemy_units);
	Unit replace_by_repairing_scv(Unit combat_unit,Unit target);
	bool storm(Unit high_templar_unit);
	static bool should_emergency_storm(Unit high_templar_unit);
	static std::pair<int,int> storm_score(Position position,const std::vector<std::pair<Unit,int>>& unit_scores);
	bool stasis(Unit arbiter_unit);
	std::pair<int,int> stasis_score(Position arbiter_position,Position statis_position,const std::vector<std::pair<Unit,int>>& unit_scores);
	static bool bullet_postion_list_intersects(const std::vector<Position>& positions,Position candidate,int size);
	void apply_worker_need_detection();
	Position MicroManager::calculate_single_target_position();
	void update_run_by();
	void end_run_by();
	std::set<Unit> determine_run_by_units_near_bunker(Position bunker_position,Position target_position);
	static Unit determine_bunker_for_run_by(Position target_position);
	static bool check_run_by_damage(Unit bunker,const std::set<Unit>& units_near_bunker);
};
