#include "BananaBrain.h"

void DebugOptions::init()
{
	FILE *f;
	int err = fopen_s(&f, "bwapi-data\\AI\\DebugOptions.txt", "r");
	if (err == 0) {
		while (true) {
			char line[1024];
			if (fgets(line, sizeof(line), f) == nullptr) break;
			char key[512];
			char value[512];
			int ret = sscanf_s(line, "%[^=]=%[^\n]\n", key, sizeof(key), value, sizeof(value));
			if (ret == 2) apply_key_value(key, value);
		}
		
		fclose(f);
	}
}

void DebugOptions::apply_key_value(const char *key,const char* value)
{
	if (strcmp(key, "draw") == 0) {
		draw_enabled_ = (strcmp(value, "true") == 0);
	} else if (strcmp(key, "PvZ_opening") == 0) {
		PvZ_opening_ = value;
	} else if (strcmp(key, "PvT_opening") == 0) {
		PvT_opening_ = value;
	} else if (strcmp(key, "PvP_opening") == 0) {
		PvP_opening_ = value;
	} else if (strcmp(key, "PvU_opening") == 0) {
		PvU_opening_ = value;
	}
}
