#pragma once

#include "Common.h"
#include "InformationManager.h"
#include "WorkerManager.h"
#include "BuildOrder.h"
#include "BuildOrderQueue.h"

namespace UAlbertaBot
{
typedef std::pair<MacroAct, size_t> MetaPair;
typedef std::vector<MetaPair> MetaPairVector;

struct Strategy
{
    std::string _name;
    BWAPI::Race _race;
	std::string _openingGroup;
    BuildOrder  _buildOrder;

    Strategy()
        : _name("None")
        , _race(BWAPI::Races::None)
 		, _openingGroup("")
    {
    }

	Strategy(const std::string & name, const BWAPI::Race & race, const std::string & openingGroup, const BuildOrder & buildOrder)
        : _name(name)
        , _race(race)
		, _openingGroup(openingGroup)
		, _buildOrder(buildOrder)
	{
    }
};

class The;

class StrategyManager 
{
	StrategyManager();

	The & the;

	BWAPI::Race					    _selfRace;
	BWAPI::Race					    _enemyRace;
    std::map<std::string, Strategy> _strategies;
    int                             _totalGamesPlayed;
    const BuildOrder                _emptyBuildOrder;
	std::string						_openingGroup;
	bool							_hasDropTech;
	int								_highWaterBases;				// most bases we've ever had, terran and protoss only
	bool							_openingStaticDefenseDropped;	// make sure we do this at most once ever

	///////////7.17.2019
	std::string                     _lastModule;//һģ
	std::string                     _currentModule;//ǰĲģ
	std::vector<std::string>        _previousModule;//֮ǰʹùвģ飬ʹ˳¼֮
	bool                            _startModuleC;
	bool                            _buildSecondBase;
	bool                            _eBayIsLifted;
	int                             _numFreeFactory;
	bool                            _buildSecondBaseIn;
	///////////7.17.2019


    const	MetaPairVector		    getProtossBuildOrderGoal();
	const	MetaPairVector		    getTerranBuildOrderGoal();
	const	MetaPairVector		    getZergBuildOrderGoal() const;

	bool							detectSupplyBlock(BuildOrderQueue & queue) const;
	bool							handleExtremeEmergency(BuildOrderQueue & queue);

	bool							canPlanBuildOrderNow() const;
	void							performBuildOrderSearch();

public:
    
	static	StrategyManager &	    Instance();
	const	bool				    shouldExpandNow() const;

            void                    addStrategy(const std::string & name, Strategy & strategy);
			void					setOpeningGroup();
	const	std::string &			getOpeningGroup() const;
 	const	MetaPairVector		    getBuildOrderGoal();
	const	BuildOrder &            getOpeningBookBuildOrder() const;

			void					handleUrgentProductionIssues(BuildOrderQueue & queue);
			void					freshProductionPlan();

			bool					dropIsPlanned() const;
			bool					hasDropTech();
////////////////////////////////++
			std::vector<int>        numAttackUnitAdd();//Ҫӵеĵλ
			std::vector<int>        isMechanicalUnitAdd();//ݾ״жǷӵλ

			bool                    enemyFlyArmyGroup();//жϵзǷΪеλ
			bool                    shouldBuildEBay();//жǷҪ޽
			bool                    shouldBuildBunker();
			bool                    shouldBuildTurret();
			bool                    shouldBuildCenter();
			bool                    shouldBuildFactory();

			void                    executeStrategy(BuildOrderQueue & queue);//µǰĽ͵λֵʵ֣Ϸ״̬ĸµ
			void                    updateCommonState(BuildOrderQueue & queue);//вͨõ״̬£˿ڽֻ׶е
			void                    doSwitchModule();//ʱѧϰģ飬вԵл
			void                    shouldSwitchModule();//µĲл

			void                    updateAntiRush(BuildOrderQueue & queue);//ԿĿ
			void                    updateDefault(BuildOrderQueue & queue);//6.29//ĬϿ
			void                    update8BB(BuildOrderQueue & queue);//7.1//Ӧһֲ
			//////////////++6.24
			bool                    openingFinished();//ֽúصֵΪtrue
			//////////////__6.24
			bool                    shouldUpgrade(BWAPI::UpgradeType type);//7.4//ݵǰжǷҪеλĹͷ

			//////////////7.17
			void                    drawModuleInformation();
			void                    updateModuleA1(BuildOrderQueue & queue);
			void                    updateModuleA2(BuildOrderQueue & queue);//8SCV޹ر·
			void                    updateModuleA3(BuildOrderQueue & queue);//8SCV޹޵ر
			void                    updateModuleA4(BuildOrderQueue & queue);//8BB
			void                    updateModuleB1(BuildOrderQueue & queue);//ǹRush
			void                    updateModuleB2(BuildOrderQueue & queue);
			void                    updateModuleB3(BuildOrderQueue & queue);
			void                    updateModuleB4(BuildOrderQueue & queue);
			void                    updateModuleB5(BuildOrderQueue & queue);//췢չ,
			void                    updateModuleB6(BuildOrderQueue & queue);
			void                    updateModuleB7(BuildOrderQueue & queue);//

			void                    updateModuleC(BuildOrderQueue & queue);//CҲĳɼʱģʽ

			const MetaPairVector    updateModuleC1();
			std::string             getCurrentModule(){ return _currentModule; };
			bool                    enemyUnitsFrontPosition(BWAPI::Position currentPos, BWAPI::Position referencePos, bool isFront);//жǷезλڼſ
			//////////////7.17

			bool                    isSecondBaseReady(){ return _buildSecondBase; };//8.7.2019//ǷʼŶ//ӷֻصĵرпʼútrue
			void                    setEbayIsLifted(bool isLifted){ _eBayIsLifted = isLifted; };//8.7.2019
			void                    buildTurret(BuildOrderQueue & queue, int aimNumOfBaseTurret, int numChoke1, int numChoke2);//8.8.2019//޽غ·ڵķ̨CΪʹshouldBuildTurret()޽ϵķ̨
			void                    buildBaseTurret(BuildOrderQueue & queue);//8.22.2019//ֻصķɷ̨
			bool                    shouldBuildSecondBaseIn(){ return _buildSecondBaseIn; };
////////////////////////////////__

};

}