#include "Common.h"
#include "PathFinding.h"
#include "MapTools.h"

namespace { auto & bwemMap = BWEM::Map::Instance(); }

using namespace UAlbertaBot;


int PathFinding::GetGroundDistance(BWAPI::Position start, BWAPI::Position end, BWAPI::UnitType unitType, PathFindingOptions options)
{
    // Parse options
    bool useNearestBWEMArea = ((int)options & (int)PathFindingOptions::UseNearestBWEMArea) != 0;

    // If either of the points is not in a BWEM area, fall back to air distance unless the caller overrides this
    if (!useNearestBWEMArea && (!bwemMap.GetArea(BWAPI::WalkPosition(start)) || !bwemMap.GetArea(BWAPI::WalkPosition(end))))
        return start.getApproxDistance(end);

    int dist;
    GetChokePointPath(start, end, unitType, options, &dist);
    return dist;
}

const BWEM::CPPath PathFinding::GetChokePointPath(
    BWAPI::Position start, 
    BWAPI::Position end, 
    BWAPI::UnitType unitType,
    PathFindingOptions options,
    int* pathLength)
{
    if (pathLength) *pathLength = -1;

    // Parse options
    bool useNearestBWEMArea = ((int)options & (int)PathFindingOptions::UseNearestBWEMArea) != 0;

    // If either of the points is not in a BWEM area, it is probably over unwalkable terrain
    if (!useNearestBWEMArea && (!bwemMap.GetArea(BWAPI::WalkPosition(start)) || !bwemMap.GetArea(BWAPI::WalkPosition(end))))
        return BWEM::CPPath();

    // Start with the BWEM path
    auto bwemPath = bwemMap.GetPath(start, end, pathLength);
	return bwemPath;//@zhang 20199413:15:38   
}

