#include "Common.h"
#include "LocutusUnit.h"
#include "InformationManager.h"
#include "Micro.h"
#include "MapTools.h"
#include "PathFinding.h"

const double pi = 3.14159265358979323846;

namespace { auto & bwemMap = BWEM::Map::Instance(); }

using namespace UAlbertaBot;

LocutusUnit::LocutusUnit()
	: the(The::Root())
	, targetPosition(BWAPI::Positions::Invalid)
	, currentlyMovingTowards(BWAPI::Positions::Invalid)
{
}


bool LocutusUnit::moveTo(BWAPI::Unit unit,BWAPI::Position position)
{
    // Fliers just move to the target
    if (unit->isFlying())
    {
		//Move(unit, position);
        //Micro::Instance().Move(unit, position);
		//unit->move(position);//ZTODO @zhang 20199316:41:07 Ϊmicromove
		the.micro.Move(unit, position);
        return true;
    }

    // If the unit is already moving to this position, don't do anything
    BWAPI::UnitCommand currentCommand(unit->getLastCommand());
    //if (position == targetPosition ||
	if (position == targetPosition &&//@zhang 20199512:44:29 ֹ趨targetPositionpositionֱͬreturnµλƶһ·ھͲ
        (currentCommand.getType() == BWAPI::UnitCommandTypes::Move && currentCommand.getTargetPosition() == position))
		//@zhang 20199513:41:58 ZTODO ·ϣжٸwaypoint᲻ỹ֮ǰ򣬵²
        return true;

	//@zhang 20199513:44:20 ifû&&ҪȥcurrentCommand.getTargetPosition()currentlyMovingTowardsһ
	if (unit->getDistance(currentCommand.getTargetPosition()) >20&& (currentCommand.getTargetPosition()==currentlyMovingTowards))
	{
		return true;
	}
    // Clear any existing waypoints
    waypoints.clear();
    targetPosition = BWAPI::Positions::Invalid;
    currentlyMovingTowards = BWAPI::Positions::Invalid;

    // If the unit is already in the same area, or the target doesn't have an area, just move it directly
    auto targetArea = bwemMap.GetArea(BWAPI::WalkPosition(position));
    if (!targetArea || targetArea == bwemMap.GetArea(BWAPI::WalkPosition(unit->getPosition())))
    {
		//Move(unit, position);

        //Micro::Move(unit, position);
		//Micro::Instance().Move(unit, position);
		//unit->move(position);//ZTODO @zhang 20199316:41:07 Ϊmicromove
		the.micro.Move(unit, position);


        return true;
    }

    // Get the BWEM path
    // TODO: Consider narrow chokes
    auto& path = PathFinding::GetChokePointPath(
        unit->getPosition(), 
        position, 
        unit->getType(),
        PathFinding::PathFindingOptions::UseNearestBWEMArea);
    if (path.empty()) return false;

    for (const BWEM::ChokePoint * chokepoint : path)
        waypoints.push_back(chokepoint);

    // Start moving
    targetPosition = position;
    moveToNextWaypoint(unit);
    return true;
}
void LocutusUnit::moveToNextWaypoint(BWAPI::Unit unit)
//void LocutusUnit::moveToNextWaypoint()
{
    // If there are no more waypoints, move to the target position
    // State will be reset after latency frames to avoid resetting the order later
    if (waypoints.empty())
    {
		//Move(unit, targetPosition);

        //Micro::Move(unit, targetPosition);
		//Micro::Instance().Move(unit, targetPosition);
		//unit->move(targetPosition);//ZTODO @zhang 20199316:41:07 Ϊmicromove
		the.micro.Move(unit, targetPosition);


        //lastMoveFrame = BWAPI::Broodwar->getFrameCount();
        return;
    }

    const BWEM::ChokePoint * nextWaypoint = *waypoints.begin();

   
    // Determine the position on the choke to move towards

    // If it is a narrow ramp, move towards the point with highest elevation
    // We do this to make sure we explore the higher elevation part of the ramp before bugging out if it is blocked
	//@zhang 20199413:38:31
    /*ChokeData & chokeData = *((ChokeData*)nextWaypoint->Ext());
    if (chokeData.width < 96 && chokeData.isRamp)
    {
        currentlyMovingTowards = BWAPI::Position(chokeData.highElevationTile) + BWAPI::Position(16, 16);
    }
    else
    {*/

    // Get the next position after this waypoint
    BWAPI::Position next = targetPosition;//@zhang 20199511:27:19 nextĿ
    if (waypoints.size() > 1) next = BWAPI::Position(waypoints[1]->Center());//@zhang 20199511:32:50 һ·ڵм

    //// Move to the part of the choke closest to the next position
    //int bestDist = INT_MAX;
    //for (auto walkPosition : nextWaypoint->Geometry())
    //{
    //    BWAPI::Position pos(walkPosition);
    //    int dist = pos.getApproxDistance(next);
    //    if (dist < bestDist)
    //    {
    //        bestDist = dist;
    //        currentlyMovingTowards = pos;
    //    }
    //}
	//@zhang 20199418:47:48 жڵλҪȥط̫ȥһ·
	/*if (unit->getDistance(currentlyMovingTowards) < 10)
	{
		currentlyMovingTowards= BWAPI::Position(next);//@zhang ֱܻȥм䣬˼ǻûpointж
	}*/

    //}
	currentlyMovingTowards = BWAPI::Position(next);//@zhang 20199418:35:27

	//Move(unit, currentlyMovingTowards);
    //Micro::Move(unit, currentlyMovingTowards);
	//Micro::Instance().Move(unit, currentlyMovingTowards);
	//unit->move(currentlyMovingTowards);//ZTODO @zhang 20199316:41:07 Ϊmicromove
	the.micro.Move(unit, currentlyMovingTowards);

    //lastMoveFrame = BWAPI::Broodwar->getFrameCount();
}


LocutusUnit & LocutusUnit::Instance()//@zhang 20199415:41:32
{
	static LocutusUnit instance;
	return instance;
}