#pragma once

#include "Common.h"
#include "Squad.h"
#include "SquadData.h"
#include "InformationManager.h"
#include "StrategyManager.h"
#include "The.h"

namespace UAlbertaBot
{
class CombatCommander
{
	The &			the;
	SquadData       _squadData;
    BWAPI::Unitset  _combatUnits;
    bool            _initialized;

	bool			_goAggressive;

	BWAPI::Position	_scourgeTarget;

	BWAPI::Position	_reconTarget;
	int				_lastReconTargetChange;         // frame number

	void            updateIdleSquad();
	void            updateOverlordSquad();
	void			updateScourgeSquad();
	void			updateReconSquad();
	void			updateWatchSquads();
	void            updateBaseDefenseSquads();
	void            updateScoutDefenseSquad();
	void            updateDropSquads();
	///////////////////////////++
	int             spiderStep;          //¼֩׵ķò
	BWAPI::Position	defenseLine;         //ߵλ
	BWAPI::Position _lastDefenseLine;
	int             _lastScanMinute;      //¼ϴʹ״̽зصʱ
	bool            _barracksIsWorking;
	BWAPI::Unit     _clostestUnit;       //Էҷλ
	BWAPI::Position _aimEnemyBase;
	///////////////////////////__

	bool            wantSquadDetectors() const;
	void			maybeAssignDetector(Squad & squad, bool wantDetector);

	void			loadOrUnloadBunkers();
	void			doComsatScan();

	int				weighReconUnit(const BWAPI::Unit unit) const;
	int				weighReconUnit(const BWAPI::UnitType type) const;

	bool			isFlyingSquadUnit(const BWAPI::UnitType type) const;
	bool			isOptionalFlyingSquadUnit(const BWAPI::UnitType type) const;
	bool			isGroundSquadUnit(const BWAPI::UnitType type) const;

	bool			unitIsGoodToDrop(const BWAPI::Unit unit) const;

	void			cancelDyingItems();

	int             getNumType(BWAPI::Unitset & units, BWAPI::UnitType type);

	BWAPI::Unit     findClosestDefender(const Squad & defenseSquad, BWAPI::Position pos, bool flyingDefender, bool pullWoekers, bool enemyHasAntiAir);
    BWAPI::Unit     findClosestWorkerToTarget(BWAPI::Unitset & unitsToAssign, BWAPI::Unit target);

	void			chooseScourgeTarget(const Squad & squad);
	BWAPI::Position getDefendLocation();
	void			chooseReconTarget();
	BWAPI::Position getReconLocation() const;
	SquadOrder		getAttackOrder(const Squad * squad);
	BWAPI::Position getAttackLocation(const Squad * squad);
	BWAPI::Position getDropLocation(const Squad & squad);
	BWAPI::Position	getDefenseLocation();

    void            initializeSquads();
    void            assignFlyingDefender(Squad & squad);
    void            emptySquad(Squad & squad, BWAPI::Unitset & unitsToAssign);
    int             getNumGroundDefendersInSquad(Squad & squad);
    int             getNumAirDefendersInSquad(Squad & squad);

	void            updateDefenseSquadUnits(Squad & defenseSquad, const size_t & flyingDefendersNeeded, const size_t & groundDefendersNeeded, bool pullWorkers, bool enemyHasAntiAir);

    int             numZerglingsInOurBase() const;
    bool            buildingRush() const;


public:

	CombatCommander();

	void update(const BWAPI::Unitset & combatUnits);

	void setAggression(bool aggressive) { _goAggressive = aggressive; };
	bool getAggression() const { return _goAggressive; };
	
	void pullWorkers(int n);
	void releaseWorkers();
	
	void drawSquadInformation(int x, int y);
	void drawCombatSimInformation();

	//////////////////////////////////////////++

	void            updateDefenseLine();             //ʵʱ·ߵλ
	BWAPI::Position getDefenseLine();     //ȡ
	void            updateAttackEnemyBase(); //8.16.2019//ĿǰҪĵзֻأûΪ
	void            updateAggression();
	bool            isTimeToPush();//8.30.2019//ݵ˫λλãжҷǷӦƽ

	BWAPI::Position getNearPosition(BWAPI::Position frontPos, BWAPI::Position backPos, bool isFront, int distance);//ȡǰߺָһ
	BWAPI::Position getRowPosition(BWAPI::Position frontPos, BWAPI::Position backPos, int interval, int length);
	void            updateChokeSquads();
	void            updateSpiderSquads();//֩׵ĲӵһУ֮öУͬʱǰ//8.12.2019Ѿ
	void            updateFrontSquads();//ߵУ
	void            updateGoliathSquad();//8.18.2019
	void            updateBaseAttackSquad();//8.18.2019
	void            updateTankSquads();//ߵ̹˶Уλмƫλ
	void            updatePioneerSquad();//׳Ϊȷ棬Ϊ̹˵ֵзĳ
	void            updateBunkerSquad();//ÿһsquad4ǹɣפڵرڣԶƽıפصĵر
	void            updateStartingBaseDefenseSquad();//طǳҪҪ൥λӦԵзĽ
	void            updateB3Squad();
	BWAPI::Position getSquadPosition(std::string squadID);//ԵǰķصΪģȷеλã
	void            updateAttackSquads();//7.18
	void            clearSquad(std::string squadName);
	void            updateMineAsRowFrontSquad(BWAPI::Position aimPosition, BWAPI::Position backPos, int interval, int length, bool doubleLine);//ǰ׵׳ 
	void            updateMineAsRowBackSquad(BWAPI::Position aimPosition, BWAPI::Position backPos, int interval, int length);//ں׵׳ 
	bool            canUseMinePosition(BWAPI::Position targetPos);
	void            updateScvSquad();
	void            updateResidentBaseSquad();//8.9.2019//غͶ
	void            updateScoutSquad();//8.14.2019//2׳Сӣڷֻ
	void            updateScvScoutSquad();//8.14.2019//ǰڷز㣬ʹSCV
	void            updateHarassSquad();//9.2.2019//׳̹˵ǰɧŶԷ
	void            updateFindingEnemyBaseSquad();//9.8.2019/Ѱҵз
	////////////
	void 	        updateBarracks();             //·ڴĽ߽//7.31.2019//ӪΪǰṩҰ
	void            updateBarracksIsWorking();
	void            updateClostestUnit();
	////////////
	BWAPI::Position frontBarracksPosition();//ӪڣNone
	BWAPI::Unit     getFrontBarracks();
	//////////////////////////////////////////__
	//8.4.2019 @liang
	BWAPI::Position getPointBetweenCC_Mineral();
	void            updateMineCC_MineralSquad();

	void            liftAndMoveEbay(); //8.7.2019//𹤳,ƶϷ
	void            updateSecondBase();//8.29.2019//޵ĶؽҪɵӦλ

	static CombatCommander & Instance();

	static int		workerPullScore(BWAPI::Unit worker);//@zhang 201983021:25:17 ΪpublicΪPullWorkerCompareʹ

};

struct PullWorkerCompare //дº//@zhang 201983021:25:17 ޸lambdaΪstruct
{
	bool operator() (BWAPI::Unit left, BWAPI::Unit right)
	{
		return CombatCommander::workerPullScore(left) < CombatCommander::workerPullScore(right); //󶥶
	}
};
}
