#pragma once

#include "BuildingData.h"

namespace UAlbertaBot
{
class The;

class BuildingPlacer
{
	The & the;
    std::vector< std::vector<bool> > _reserveMap;

	BuildingPlacer();

	void				reserveSpaceNearResources();

	// determines whether we can build at a given location
	bool				canBuildHere(BWAPI::TilePosition position, const Building & b) const;
	bool				canBuildHereWithSpace(BWAPI::TilePosition position, const Building & b, int buildDist) const;
	bool	freeOnTop(const BWAPI::TilePosition & tile, BWAPI::UnitType buildingType) const;
	bool	freeOnRight(const BWAPI::TilePosition & tile, BWAPI::UnitType buildingType) const;
	bool	freeOnLeft(const BWAPI::TilePosition & tile, BWAPI::UnitType buildingType) const;
	bool	freeOnBottom(const BWAPI::TilePosition & tile, BWAPI::UnitType buildingType) const;
	bool	freeTile(int x, int y) const;
	//////////////////////++6.23
	BWAPI::Position bunkerBuildPlace;
	BWAPI::Position TurretBuildPlace;
	
	//////////////////////__6.23

public:

    static BuildingPlacer & Instance();

    // queries for various BuildingPlacer data
	bool				buildable(const Building & b, int x, int y) const;
	bool				isReserved(int x, int y) const;
	bool				tileOverlapsBaseLocation(BWAPI::TilePosition tile, BWAPI::UnitType type) const;
    bool				tileBlocksAddon(BWAPI::TilePosition position) const;

    // returns a build location near a building's desired location
    BWAPI::TilePosition	getBuildLocationNear(const Building & b, int buildDist) const;

	void				reserveTiles(BWAPI::TilePosition position, int width, int height);
    void				freeTiles(BWAPI::TilePosition position, int width,int height);

    void				drawReservedTiles();

    BWAPI::TilePosition	getRefineryPosition();
	//////////////////

	BWAPI::TilePosition getBunkerPosition(const Building & b, int numBunker);
	BWAPI::TilePosition getSupplyDepotPosition(const Building & b, int numSD);
	BWAPI::TilePosition getBarracksPosition(const Building & b, int numBarracks);
	BWAPI::TilePosition getEdgeBuildingPosition(const Building & b);
	BWAPI::TilePosition getUnitBuildingPosition(const Building & b);
	BWAPI::TilePosition getTurretPosition(const Building & b, int num);
	BWAPI::TilePosition getFactoryPosition(const Building & b, int num);
	BWAPI::TilePosition getNearBasePosition(const Building & b);
	BWAPI::Position     getBaseTurretPosition(const Building & b);//8.7.2019//غͿ֮ȡһλãڽ̨
	void                setBunkerBuildPlace(BWAPI::Position pos){ bunkerBuildPlace = pos; };
	void                setTurretBuildPlace(BWAPI::Position pos){ TurretBuildPlace = pos; };
	bool                allowBuildTuttet;
	bool                allowBuildSupply;
	BWAPI::TilePosition	getBuildLocationNear(const Building & b, int buildDist, BWAPI::Position center) const;

    //////////////////
};
}