#pragma once
#include <BWAPI.h>
#include "BaseFinderJaj22.h"
#include "Namespace.h"
#include "Info.h"
#include "ReadWrite.h"
#include "MapAnalysis.h"
#include "MapUtilities.h"
#include "ExpoList.h"
#include "ExpoFinder.h"
#include "UnitList.h"
#include "BuildList.h"
#include "EnemyList.h"
#include "BuildManager.h"
#include "TrainManager.h"
#include "ArmyManager.h"
#include "MiningManager.h"
#include "Detection.h"
#include "Scout.h"
#include "Repair.h"

// Remember not to use "Broodwar" in any global class constructor!

//willyt history:
//2018-03-06: start with renaming the example-ai-module
//2018-04-02: later april fools upload
//2018-04-07: division by zero :D (average medic energy)
//2018-06-24: added many new features: namespace, bunker, +1/+1, expanding, mining distribution
//2018-06-24: first win vs 2 standard AIs, still potato & crash bugs lurking
//2018-10-05: finished preparations for the submission to AIIDE 2018

//written by Nico Klausner (WillBotSC) 2018
//modified ExampleAIModule
//using BWAPI 4.2.0
//using BaseFinder written by Jaj22
//thanks for the help in SSCAIT discord chat: N00byEdge and others

class WillytAI : public BWAPI::AIModule
{
public:

	// Virtual functions for callbacks, leave these as they are.
	virtual void onStart();
	virtual void onEnd(bool isWinner);
	virtual void onFrame();
	virtual void onSendText(std::string text);
	virtual void onReceiveText(BWAPI::Player player, std::string text);
	virtual void onPlayerLeft(BWAPI::Player player);
	virtual void onNukeDetect(BWAPI::Position target);
	virtual void onUnitDiscover(BWAPI::Unit unit);
	virtual void onUnitEvade(BWAPI::Unit unit);
	virtual void onUnitShow(BWAPI::Unit unit);
	virtual void onUnitHide(BWAPI::Unit unit);
	virtual void onUnitCreate(BWAPI::Unit unit);
	virtual void onUnitDestroy(BWAPI::Unit unit);
	virtual void onUnitMorph(BWAPI::Unit unit);
	virtual void onUnitRenegade(BWAPI::Unit unit);
	virtual void onSaveGame(std::string gameName);
	virtual void onUnitComplete(BWAPI::Unit unit);
	// Everything below this line is safe to modify.

	Info info;
	ExpoList expolist;
	ExpoFinder expofinder;
	MapAnalysis mapanalysis;
	UnitList unitlist;
	EnemyList enemylist;
	BuildManager buildmanager;
	TrainManager trainmanager;
	ArmyManager armymanager;
	MiningManager miningmanager;
	Detection detection;
	Scout scout;
	Repair repair;

};