#include "WillytAI.h"

void WillytAI::onStart() {
	BWAPI::Broodwar->enableFlag(1);
	BaseFinderJaj22::Init(expolist);
	mapanalysis.create_all_maps();
	mapanalysis.fill_build_map(expolist.all);
	armymanager.update_positions();
	buildmanager.init();

	//BWAPI::Broodwar->printf( str.c_sctr(defender.center_pos) );
	//BWAPI::Broodwar->printf("console?");
	//call AllocConsole, windows.h, freopen("CONOUT$", "w", stdout);
}

void WillytAI::onEnd(bool isWinner) {
	BWAPI::Broodwar->sendText( write_logfile(enemylist.name, enemylist.race.toString(), 1, isWinner) );
	BWAPI::Broodwar->sendText("gg");
}

void WillytAI::onFrame() {
	// Return if the game is a replay or is paused
	if (BWAPI::Broodwar->isReplay() ||
		BWAPI::Broodwar->isPaused() ||
		!BWAPI::Broodwar->self()) {
		return;
	}
	int n = BWAPI::Broodwar->getFrameCount();
	if (n % 512 == 256) {
		expofinder.check(expolist.all, enemylist.positions);
		unitlist.update_supply_tresholds();
		unitlist.adress_renegade_scv();
		enemylist.correct();
	}
	else if (n % 64 == 32) {
		detection.check();
		repair.check();
		trainmanager.check_upgrades();
		expolist.update();
		miningmanager.check_min(expolist.all);
		miningmanager.check_gas(expolist.all);
		buildmanager.update_turrets(enemylist.supply_air, enemylist.supply_cloak);
		scout.update_other();
	}
	else if (n % 8 == 4) {
		buildmanager.build_buildings();
		trainmanager.train_units(enemylist);
		buildmanager.update_defense(scout.unit);
	}
	else if (n % 4 == 2) {
		armymanager.update(enemylist);
	}
	else {
		scout.update_scout();
		unitlist.update_scvs();
		unitlist.update_marines();
		unitlist.update_firebats();
		unitlist.update_tanks();
	}

	//show_map(willyt::build_map, false);
	expolist.draw_expos();
	buildmanager.draw_defense();
	draw_tile_list(willyt::minerals, 2, 1, 128);
	draw_tile_list(willyt::geysers, 4, 2, 128);
	info.display(enemylist);
	//info.draw_256_colors();
}

void WillytAI::onSendText(std::string text) {}

void WillytAI::onReceiveText(BWAPI::Player player, std::string text) {}

void WillytAI::onPlayerLeft(BWAPI::Player player) {}

void WillytAI::onSaveGame(std::string gameName) {}

void WillytAI::onNukeDetect(BWAPI::Position target) {}

void WillytAI::onUnitDiscover(BWAPI::Unit unit) {
	if (unit->getPlayer()->isEnemy(BWAPI::Broodwar->self()))
		enemylist.append_unit(unit);
}

void WillytAI::onUnitEvade(BWAPI::Unit unit) {}

void WillytAI::onUnitShow(BWAPI::Unit unit) {}

void WillytAI::onUnitHide(BWAPI::Unit unit) {}

void WillytAI::onUnitCreate(BWAPI::Unit unit) {
	if (unit->getPlayer() == BWAPI::Broodwar->self()) {
		if (!unit->getType().isBuilding()) {
			unitlist.tcount_unit(unit);
		}
		if (unit->getType().isBuilding()) {
			append_building(unit);
			mapanalysis.add_def_map(unit->getTilePosition(), unit->getType(), 5);
		}
		if (unit->getType() == BWAPI::UnitTypes::Terran_Command_Center) {
			expolist.occupy_expo(unit->getTilePosition());
			mapanalysis.add_def_map(unit->getTilePosition(), unit->getType(), 7);
			armymanager.update_positions();
		}
		if (unit->getType() == BWAPI::UnitTypes::Terran_Bunker) {
			armymanager.update_positions();
		}
	}
}

void WillytAI::onUnitDestroy(BWAPI::Unit unit) {
	if (unit->getPlayer() == BWAPI::Broodwar->self()) {
		if (!unit->getType().isBuilding()) {
			unitlist.remove_unit(unit);
		}
		if (unit->getType().isBuilding()) {
			remove_building(unit);
		}
		if (unit->getType() == BWAPI::UnitTypes::Terran_Command_Center) {
			expolist.desert_expo(unit->getTilePosition());
		}
	}
	else if (unit->getPlayer()->isEnemy(BWAPI::Broodwar->self())) {
		enemylist.remove_unit(unit);
	}
	else if (unit->getType().isMineralField()) {
		expolist.mined_out(unit);
		set_map_area_unit(willyt::build_map, unit, true);
	}
}

void WillytAI::onUnitMorph(BWAPI::Unit unit) {
	if (unit->getPlayer() == BWAPI::Broodwar->self() &&
		unit->getType() == BWAPI::UnitTypes::Terran_Refinery) {
		append_building(unit);
	}
	else if (unit->getPlayer()->isEnemy(BWAPI::Broodwar->self())) {
		enemylist.change_unit(unit);
	}
}

void WillytAI::onUnitRenegade(BWAPI::Unit unit) {
	if (unit->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser ||
		unit->getType().isAddon()) {
		remove_building(unit);
		enemylist.remove_unit(unit);
	}
}

void WillytAI::onUnitComplete(BWAPI::Unit unit) {
	if (unit->getPlayer() == BWAPI::Broodwar->self() &&
		!unit->getType().isBuilding()) {
		unitlist.append_unit(unit);
	}
}
