#include "Utilities.h"

void safe_substract(int &n, int m) {
	if (n > m)  { n = n - m; }
	else		{ n = 0; }
}

void vector_remove_unit(std::vector<BWAPI::Unit> &v, BWAPI::Unit u) {
	v.erase(std::remove(v.begin(), v.end(), u), v.end());
}

void draw_tile_list(std::vector<BWAPI::Unit> &my_list, int w, int h, int my_color) {
	for (BWAPI::Unit &my_unit : my_list) {
		draw_tile_box(my_unit->getTilePosition(), w, h, my_color);
	}
}

void draw_tile_box(BWAPI::TilePosition &tile, int dx, int dy, int color) {
	int x1 = 32 * tile.x;
	int y1 = 32 * tile.y;
	int x2 = x1 + 32 * dx;
	int y2 = y1 + 32 * dy;
	BWAPI::Broodwar->drawBoxMap(x1, y1, x2, y2, BWAPI::Color(color), false);
}