#include "UnitList.h"

void UnitList::tcount_unit(BWAPI::Unit unit) {
	BWAPI::UnitType t = unit->getType();
	if (t == BWAPI::UnitTypes::Terran_SCV)			{ ++willyt::tcount_scv; }
	else if (t == BWAPI::UnitTypes::Terran_Marine)  { ++willyt::tcount_marine; }
	else if (t == BWAPI::UnitTypes::Terran_Firebat) { ++willyt::tcount_firebat; }
	else if (t == BWAPI::UnitTypes::Terran_Medic)	{ ++willyt::tcount_medic; }
	else if (t == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode)	{ ++willyt::tcount_siegetank; }
	else if (t == BWAPI::UnitTypes::Terran_Goliath)	{ ++willyt::tcount_goliath; }
}

void UnitList::append_unit(BWAPI::Unit unit) {
	if (unit->getType() == BWAPI::UnitTypes::Terran_SCV) {
		SCV scv(unit);
		willyt::scvs.push_back( scv );
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Marine) {
		Marine marine(unit, willyt::start_pos);
		willyt::marines.push_back(marine);
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Firebat) {
		Firebat firebat(unit, willyt::start_pos);
		willyt::firebats.push_back(firebat);
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Medic) {
		Medic medic(unit);
		willyt::medics.push_back(medic);
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode) {
		for (std::size_t i = 0; i < willyt::siegetanks.size(); ++i) {
			if (willyt::siegetanks[i].id == unit->getID()) { return; }
		}
		SiegeTank siegetank(unit);
		willyt::siegetanks.push_back(siegetank);
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Goliath) {
		Goliath goliath(unit);
		willyt::goliaths.push_back(goliath);
	}
}

void UnitList::remove_unit(BWAPI::Unit unit) {
	if (unit->getType() == BWAPI::UnitTypes::Terran_SCV) {
		for (std::size_t i = 0; i < willyt::scvs.size(); ++i) {
			if (willyt::scvs[i].id == unit->getID()) {
				willyt::scvs.erase(willyt::scvs.begin() + i);
				break;
			}
		}
		willyt::tcount_scv--;
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Marine) {
		for (std::size_t i = 0; i < willyt::marines.size(); ++i) {
			if (willyt::marines[i].id == unit->getID()) {
				willyt::marines.erase(willyt::marines.begin() + i);
				break;
			}
		}
		willyt::tcount_marine--;
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Firebat) {
		for (std::size_t i = 0; i < willyt::firebats.size(); ++i) {
			if (willyt::firebats[i].id == unit->getID()) {
				willyt::firebats.erase(willyt::firebats.begin() + i);
				break;
			}
		}
		willyt::tcount_firebat--;
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Medic) {
		for (std::size_t i = 0; i < willyt::medics.size(); ++i) {
			if (willyt::medics[i].id == unit->getID()) {
				willyt::medics.erase(willyt::medics.begin() + i);
				break;
			}
		}
		willyt::tcount_medic--;
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode) {
		for (std::size_t i = 0; i < willyt::siegetanks.size(); ++i) {
			if (willyt::siegetanks[i].id == unit->getID()) {
				willyt::siegetanks.erase(willyt::siegetanks.begin() + i);
				break;
			}
		}
		willyt::tcount_siegetank--;
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode) {
		for (std::size_t i = 0; i < willyt::siegetanks.size(); ++i) {
			if (willyt::siegetanks[i].id == unit->getID()) {
				willyt::siegetanks.erase(willyt::siegetanks.begin() + i);
				break;
			}
		}
		willyt::tcount_siegetank--;
	}
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Goliath) {
		for (std::size_t i = 0; i < willyt::goliaths.size(); ++i) {
			if (willyt::goliaths[i].id == unit->getID()) {
				willyt::goliaths.erase(willyt::goliaths.begin() + i);
				break;
			}
		}
		willyt::tcount_goliath--;
	}
}

void UnitList::update_scvs() {
	int i = 30;
	for (SCV &scv : willyt::scvs) {
		if (scv.unit->isIdle() &&
			!scv.is_militia &&
			!scv.is_builder)
			scv.mine(willyt::minerals);
		if (scv.is_builder)
			scv.build();
		//BWAPI::Broodwar->drawTextMap(scv.unit->getPosition(), "scv");
	}
}

void UnitList::update_marines() {
	if (BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Stim_Packs) && medic_energy_enough())
		for (Marine &marine : willyt::marines)
			marine.stim();
	for (Marine &marine : willyt::marines)
		marine.retreat();
}

void UnitList::update_firebats() {
	for (Firebat &firebat : willyt::firebats)
		firebat.retreat();
}

void UnitList::update_tanks() {
	if (BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Tank_Siege_Mode))
		for (SiegeTank &siegetank : willyt::siegetanks)
			siegetank.check_siege();
}



bool UnitList::medic_energy_enough() {
	int e = 0;
	for (Medic &medic : willyt::medics)
		e += medic.unit->getEnergy();
	if (willyt::medics.size() > 0 &&
		e / willyt::medics.size() >= 25)
		return true;
	return false;
}

void UnitList::update_supply_tresholds() {
	int a = BWAPI::Broodwar->elapsedTime() / 30;
	if (a < 16) { a = 16; }
	if (BWAPI::Broodwar->enemies().size() > 1 &&
		a < 24) { a = 24; }
	if (a > 60) { a = 60; }
	willyt::attack_supply = a;

	int m = 2 * willyt::minerals.size() + 3 * willyt::refineries.size() + 3;
	if (BWAPI::Broodwar->elapsedTime() < 600) { m = 20; }
	if (m > 60) { m = 60; }
	willyt::mining_supply = m;
}

void UnitList::adress_renegade_scv() {
	for (BWAPI::Unit unit : BWAPI::Broodwar->self()->getUnits()) {
		if (unit->getType().isWorker() &&
			unit->isIdle() &&
			unit->isCompleted()) {
			SCV scv(unit);
			willyt::scvs.push_back(scv);
			//BWAPI::Broodwar->printf("adressing renegade scv");
			return;
		}
	}
}

std::vector<SCV>::iterator choose_scv(BWAPI::TilePosition my_tile) {
	int min_dis = 8192;
	auto min_scv = willyt::scvs.begin();
	for (std::vector<SCV>::iterator it = willyt::scvs.begin(); it != willyt::scvs.end(); ++it) {
		if (it->is_builder ||
			it->is_militia) {
			continue;
		}
		int my_dis = (int)it->unit->getTilePosition().getDistance(my_tile);
		if (it->unit->isCompleted() &&
			(it->unit->isGatheringMinerals() || it->unit->isIdle()) &&
			my_dis < min_dis) {
			min_dis = my_dis;
			min_scv = it;
		}
	}
	return min_scv;
}

int count_army() {
	int i = 0;
	i = i + willyt::marines.size();
	i = i + willyt::firebats.size();
	i = i + willyt::medics.size();
	i = i + 2 * willyt::siegetanks.size();
	i = i + 2 * willyt::goliaths.size();
	return i;
}

int count_militia() {
	int i = 0;
	for (SCV &scv : willyt::scvs) {
		if (scv.is_militia) { ++i; }
	}
	return i;
}