#include "TrainManager.h"

void TrainManager::train_units(EnemyList &el) {
	if (!willyt::commandcenters.empty() && 
		!willyt::academies.empty() &&
		BWAPI::Broodwar->self()->minerals() >= 50 &&
		BWAPI::Broodwar->self()->gas() >= 50)
		build_comsats();

	if (!willyt::commandcenters.empty() &&
		BWAPI::Broodwar->self()->minerals() >= 50)
		train_commandc();

	if (!willyt::barracks.empty() &&
		!saving_for_expo() &&
		BWAPI::Broodwar->self()->minerals() >= 100)
		train_barracks(el);

	if (!willyt::factories.empty() &&
		!saving_for_expo() &&
		BWAPI::Broodwar->self()->minerals() >= 100)
		train_factory(el);
}

void TrainManager::train_commandc() {
	BWAPI::Unit my_cc = find_idle(willyt::commandcenters);
	if (my_cc &&
		willyt::tcount_scv < 10) {
		my_cc->train(BWAPI::UnitTypes::Terran_SCV);
		return;
	}
	if (my_cc &&
		!willyt::barracks.empty() &&
		willyt::tcount_scv < willyt::mining_supply) {
		my_cc->train(BWAPI::UnitTypes::Terran_SCV);
		return;
	}
}

void TrainManager::train_barracks(EnemyList &el) {
	BWAPI::Unit my_barracks = find_idle(willyt::barracks);
	if (my_barracks &&
		!willyt::academies.empty() &&
		BWAPI::Broodwar->self()->gas() >= 25) {
		if (5 * willyt::tcount_medic < willyt::tcount_marine + willyt::tcount_firebat) {
			my_barracks->train(BWAPI::UnitTypes::Terran_Medic);
			return;
		}
		if (need_a_light(el)) {
			my_barracks->train(BWAPI::UnitTypes::Terran_Firebat);
			return;
		}
	}
	if (my_barracks) {
		my_barracks->train(BWAPI::UnitTypes::Terran_Marine);
		return;
	}
}

void TrainManager::train_factory(EnemyList &el) {
	BWAPI::Unit my_factory = find_idle(willyt::factories);
	if (my_factory &&
		!my_factory->getAddon() &&
		my_factory->canBuildAddon()) {
		my_factory->buildAddon(BWAPI::UnitTypes::Terran_Machine_Shop);
		return;
	}
	if (my_factory &&
		!willyt::armories.empty() &&
		need_missiles(el)) {
		my_factory->train(BWAPI::UnitTypes::Terran_Goliath);
		return;
	}
	if (my_factory) {
		my_factory->train(BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode);
		return;
	}
}

BWAPI::Unit TrainManager::find_idle(std::vector<BWAPI::Unit> my_list) {
	for (BWAPI::Unit &my_unit : my_list)
		if (my_unit->isCompleted() &&
			my_unit->isIdle())
			return my_unit;
	return NULL;
}

bool TrainManager::need_a_light(EnemyList &el) {
	int f = 4;
	if (el.race != BWAPI::Races::Terran &&
		el.supply_air + el.supply_army == 0)
		f = 1;
	if (f * willyt::tcount_firebat < willyt::tcount_marine)
		return true;
	else
		return false;
}

bool TrainManager::need_missiles(EnemyList &el) {
	if (el.supply_air > el.supply_army + el.supply_small)
		return true;
	if (el.supply_air > 0 && willyt::goliaths.empty())
		return true;
	return false;
}

bool TrainManager::saving_for_expo() {
	if (BWAPI::Broodwar->elapsedTime() > 720 &&
		BWAPI::Broodwar->self()->minerals() < 500 &&
		willyt::tcount_scv >= willyt::mining_supply &&
		willyt::minerals.size() < 12)
		return true;
	return false;
}

void TrainManager::build_comsats() {
	for (BWAPI::Unit &my_cc : willyt::commandcenters) {
		if (my_cc->isCompleted() &&
			my_cc->isIdle() &&
			!my_cc->getAddon() &&
			my_cc->canBuildAddon()) {
			my_cc->buildAddon(BWAPI::UnitTypes::Terran_Comsat_Station);
			return;
		}
	}
}



void TrainManager::check_upgrades() {

	BWAPI::Unit my_academy = find_idle(willyt::academies);
	if (my_academy &&
		willyt::tcount_medic >= 2 &&
		my_academy->canResearch(BWAPI::TechTypes::Stim_Packs)) {
		my_academy->research(BWAPI::TechTypes::Stim_Packs);
		return;
		//BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Stim_Packs) == NULL &&
	}
	if (my_academy &&
		willyt::tcount_marine >= 12 &&
		my_academy->canUpgrade(BWAPI::UpgradeTypes::U_238_Shells)) {
		my_academy->upgrade(BWAPI::UpgradeTypes::U_238_Shells);
		return;
		//BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::U_238_Shells) == 0 &&
	}

	BWAPI::Unit my_machine_shop = find_idle(willyt::machineshops);
	if (my_machine_shop &&
		my_machine_shop->canResearch(BWAPI::TechTypes::Tank_Siege_Mode)) {
		my_machine_shop->research(BWAPI::TechTypes::Tank_Siege_Mode);
		//BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Tank_Siege_Mode) == NULL &&
		return;
	}
	if (my_machine_shop &&
		willyt::tcount_goliath >= 3 &&
		my_machine_shop->canUpgrade(BWAPI::UpgradeTypes::Charon_Boosters)) {
		my_machine_shop->upgrade(BWAPI::UpgradeTypes::Charon_Boosters);
		//BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Charon_Boosters) == 0 &&
		return;
	}

	BWAPI::Unit my_engybay = find_idle(willyt::engybays);
	if (my_engybay &&
		my_engybay->canUpgrade(BWAPI::UpgradeTypes::Terran_Infantry_Weapons)) {
		my_engybay->upgrade(BWAPI::UpgradeTypes::Terran_Infantry_Weapons);
		return;
		//BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Terran_Infantry_Weapons) < 1 &&
	}
	if (my_engybay &&
		my_engybay->canUpgrade(BWAPI::UpgradeTypes::Terran_Infantry_Armor)) {
		my_engybay->upgrade(BWAPI::UpgradeTypes::Terran_Infantry_Armor);
		return;
		//BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Terran_Infantry_Armor) < 1 &&
	}

	BWAPI::Unit my_armory = find_idle(willyt::armories);
	if (my_armory &&
		my_armory->canUpgrade(BWAPI::UpgradeTypes::Terran_Vehicle_Weapons)) {
		my_armory->upgrade(BWAPI::UpgradeTypes::Terran_Vehicle_Weapons);
		//BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Terran_Vehicle_Weapons) < 1 &&
		return;
	}
	if (my_armory &&
		my_armory->canUpgrade(BWAPI::UpgradeTypes::Terran_Vehicle_Plating)) {
		my_armory->upgrade(BWAPI::UpgradeTypes::Terran_Vehicle_Plating);
		//BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Terran_Vehicle_Plating) < 1 &&
		return;
	}
}