#include "Scout.h"

Scout::Scout() {
	starts.clear();
	for (BWAPI::TilePosition t : BWAPI::Broodwar->getStartLocations())
		starts.push_back(t);
	next_start = BWAPI::Broodwar->self()->getStartLocation();
	scout_queue = 0;
	unit = NULL;
}

void Scout::update_scout() {
	if (!unit) { return; }
	if (BWAPI::Broodwar->isVisible(next_start)) {
		starts.erase(std::remove(starts.begin(), starts.end(), next_start), starts.end());
		if (!starts.empty()) {
			next_start = starts.front();
			unit->move((BWAPI::Position)next_start);
			//Broodwar->sendText("change scouting target");
		}
		else {
			unit->move((BWAPI::Position)BWAPI::Broodwar->self()->getStartLocation());
			unit = NULL;
			//Broodwar->sendText("terminate scouting");
		}
	}
	if (!unit) { return; }
	if (next_start &&
		scout_queue == 0) {
		scout_queue = 256;
		unit->move((BWAPI::Position)next_start);
	}
	safe_substract(scout_queue, 1);
	BWAPI::Broodwar->drawTextMap(unit->getPosition(), "tourist");
}

void Scout::update_other() {
	assign();
	scan_starts();
	scan_random();
}

void Scout::assign() {
	if (!starts.empty() && !unit &&
		!willyt::barracks.empty()) {
		unit = choose_scv(BWAPI::Broodwar->self()->getStartLocation())->unit;
		//Broodwar->sendText("initiate scouting");
	}
}

void Scout::scan_starts() {
	if (!starts.empty() &&
		!willyt::comsatstations.empty() &&
		willyt::comsatstations.front()->getEnergy() >= 150) {
		willyt::comsatstations.front()->useTech(BWAPI::TechTypes::Scanner_Sweep, (BWAPI::Position) next_start);
		starts.erase(std::remove(starts.begin(), starts.end(), next_start), starts.end());
		BWAPI::Broodwar->printf("need a scan to scout");
	}
}

void Scout::scan_random() {
	for (BWAPI::Unit &my_comsat : willyt::comsatstations) {
		if (my_comsat->getEnergy() >= 200) {
			int rw = rand() % (BWAPI::Broodwar->mapWidth()-12) + 6;
			int rh = rand() % (BWAPI::Broodwar->mapHeight()-12) + 6;
			BWAPI::TilePosition my_tile = BWAPI::TilePosition(rw, rh);
			if (!BWAPI::Broodwar->isVisible(my_tile)) {
				my_comsat->useTech(BWAPI::TechTypes::Scanner_Sweep, (BWAPI::Position) my_tile);
			}
			//BWAPI::Broodwar->printf("random scan");
			return;
		}
	}
}