#include "SCV.h"

SCV::SCV(BWAPI::Unit my_unit) {
	id = my_unit->getID();
	unit = my_unit;
	is_militia = false;
	is_builder = false;
}

void SCV::mine(std::vector<BWAPI::Unit> &minerals) {
	if (!minerals.empty()) {
		unsigned i = 0;
		if (BWAPI::Broodwar->elapsedTime() < 900) {
			i = id % minerals.size();
		}
		else {
			i = find_closest_mineral(minerals);
		}
		if (minerals.at(i)) {
			unit->gather(minerals.at(i));
		}
		else {
			unit->gather(minerals.back());
		}
	}
	else {
		if (!BWAPI::Broodwar->getMinerals().empty()) {
			auto u = BWAPI::Broodwar->getMinerals().begin();
			unit->gather(*u);
		}
	}
	//BWAPI::Broodwar->drawTextMap(unit->getPosition(), "mine");
}

unsigned SCV::find_closest_mineral(std::vector<BWAPI::Unit> &minerals) {
	unsigned min_dist = 15000;
	unsigned min_iter = 0;
	for (unsigned i=0; i != minerals.size(); ++i) {
		unsigned my_dist = (unsigned)unit->getDistance(minerals.at(i));
		if (min_dist > my_dist) {
			min_dist = my_dist;
			min_iter = i;
		}
	}
	return min_iter;
}

void SCV::set_build_mission(BWAPI::UnitType type, BWAPI::TilePosition &tile) {
	is_builder = true;
	build_type = type;
	build_tile = tile;
	int w = build_type.tileWidth();
	int h = build_type.tileHeight();
	build_pos = BWAPI::Position(32*tile.x + 16*w, 32*tile.y + 16*h);
	int d = unit->getPosition().getApproxDistance(build_pos);
	build_queue = 4 * d;
	//BWAPI::Broodwar->printf("SCV build queue: %d", build_queue);
}

void SCV::build() {
	if (build_queue <= 0 || unit->isUnderAttack()) {
		is_builder = false;
		return;
	}
	if (unit->getPosition().getApproxDistance(build_pos) > 96) {
		unit->move(build_pos);
		build_queue -= 1;
	}
	else {
		clear_build_tiles();
		unit->build(build_type, build_tile);
		build_queue -= 8;
	}
	int w = build_type.tileWidth();
	int h = build_type.tileHeight();
	draw_tile_box(build_tile, w, h, 179);
	BWAPI::Broodwar->drawTextMap((BWAPI::Position)build_tile, build_type.c_str());
	BWAPI::Broodwar->drawTextMap(unit->getPosition(), "%d", build_queue);
}

void SCV::clear_build_tiles() {
	int x0 = 32 * build_tile.x;
	int y0 = 32 * build_tile.y;
	int x1 = x0 + 32 * build_type.tileWidth() - 1;
	int y1 = y0 + 32 * build_type.tileHeight() - 1;
	int dx = 0;
	int dy = 0;
	switch ( (BWAPI::Broodwar->getFrameCount() * 128) % 4 ) {
		case 0: dx = +128;
		case 1: dy = +128;
		case 2: dx = -128;
		case 3: dy = -128;
	}
	for (BWAPI::Unit blocker : BWAPI::Broodwar->getUnitsInRectangle(x0, y0, x1, y1)) {
		if (blocker != unit &&
			blocker->getPlayer() == BWAPI::Broodwar->self() &&
			!blocker->isFlying() &&
			!blocker->getType().isBuilding()) {
			int x = blocker->getPosition().x + dx;
			int y = blocker->getPosition().y + dy;
			blocker->move(BWAPI::Position(x, y));
		}
	}
}