#include "Repair.h"

void Repair::check() {
	if (willyt::scvs.empty())
		return;
	for (BWAPI::Unit &u : willyt::buildings) {
		check_canceling(u);
		check_continuing(u);
		check_repair(u);
	}
}

void Repair::check_canceling(BWAPI::Unit u) {
	if (!u->isCompleted() &&
		u->exists() &&
		u->isUnderAttack() &&
		u->getHitPoints() * 8 < u->getType().maxHitPoints()) {
		u->cancelConstruction();
		BWAPI::Broodwar->printf("cancel building");
	}
}

void Repair::check_continuing(BWAPI::Unit u) {
	if (!u->isCompleted() &&
		!u->isBeingConstructed() &&
		u->exists()) {
		choose_scv(u->getTilePosition())->unit->rightClick(u);
		BWAPI::Broodwar->printf("continue building");
	}
}

void Repair::check_repair(BWAPI::Unit u) {
	if (u->exists() &&
		u->isCompleted() &&
		!u->isBeingHealed()) {
		if ((u->getType() == BWAPI::UnitTypes::Terran_Bunker ||
			u->getType() == BWAPI::UnitTypes::Terran_Missile_Turret) &&
			u->getHitPoints() < u->getType().maxHitPoints()) {
			choose_scv(u->getTilePosition())->unit->repair(u);
		}
		if (u->getHitPoints()*2 < u->getType().maxHitPoints()) {
			choose_scv(u->getTilePosition())->unit->repair(u);
		}
	}
}