#include "ReadWrite.h"
#include <iostream>
#include <fstream>
#include <ctime>
#include <iterator>

std::vector<std::string> read_logfile() {
	const char* mypath = ".\\bwapi-data\\read\\willytlog.txt";
	std::vector<std::string> mydata;
	std::string myline;

	//open read file with exeption
	std::ifstream myfile(mypath);
	if (!myfile) { return mydata; }

	//read file content into vector
	while (std::getline(myfile, myline)) { mydata.push_back(myline); }

	return mydata;
}

const char* write_logfile(std::string ename, std::string erace, int strat, bool iswin) {
	const char* mypath = ".\\bwapi-data\\write\\willytlog.txt";
	std::vector<std::string> mydata = read_logfile();

	//generate string components of the date
	std::time_t timer = std::time(0);
	std::tm*    tinfo = std::localtime(&timer);
	std::string syear = std::to_string(tinfo->tm_year + 1900);
	std::string smont = std::to_string(tinfo->tm_mon + 1);
	std::string smday = std::to_string(tinfo->tm_mday);
	if (smont.length() == 1) { smont.insert(0, "0"); }
	if (smday.length() == 1) { smday.insert(0, "0"); }

	//assemble new entry
	std::string myline;
	myline += syear + smont + smday + ",";
	myline += ename + ",";
	myline += erace.substr(0,1) + ",";
	myline += "01,";
	myline += iswin ? "1" : "0";
	mydata.push_back(myline);

	//open write file with exeption
	std::ofstream myfile(mypath);
	if (!myfile) { return "unable to write log file";  }

	//write vector content into file
	std::ostream_iterator<std::string> output_iterator(myfile, "\n");
	std::copy(mydata.begin(), mydata.end(), output_iterator);

	return mypath;
}