#pragma once
#include <BWAPI.h>
#include "SCV.h"
#include "Marine.h"
#include "Firebat.h"
#include "Medic.h"
#include "SiegeTank.h"
#include "Goliath.h"

//2018-05-19: bot namespace initialized
//2018-06-17: add first use, mineral and geyser lists
//2018-06-21: transfering all unit lists here

namespace willyt
{

	//supply tresholds
	extern int attack_supply;
	extern int mining_supply;

	//unit lists/counts
	extern std::vector<SCV> scvs;
	extern std::vector<Marine> marines;
	extern std::vector<Firebat> firebats;
	extern std::vector<Medic> medics;
	extern std::vector<SiegeTank> siegetanks;
	extern std::vector<Goliath> goliaths;
	extern int tcount_scv;
	extern int tcount_marine;
	extern int tcount_firebat;
	extern int tcount_medic;
	extern int tcount_siegetank;
	extern int tcount_goliath;

	//building lists
	extern std::vector<BWAPI::Unit> buildings;
	extern std::vector<BWAPI::Unit> commandcenters;
	extern std::vector<BWAPI::Unit> refineries;
	extern std::vector<BWAPI::Unit> depots;
	extern std::vector<BWAPI::Unit> barracks;
	extern std::vector<BWAPI::Unit> factories;
	extern std::vector<BWAPI::Unit> bunkers;
	extern std::vector<BWAPI::Unit> turrets;
	extern std::vector<BWAPI::Unit> academies;
	extern std::vector<BWAPI::Unit> armories;
	extern std::vector<BWAPI::Unit> engybays;
	extern std::vector<BWAPI::Unit> comsatstations;
	extern std::vector<BWAPI::Unit> machineshops;

	//resource lists
	extern std::vector<BWAPI::Unit> minerals;
	extern std::vector<BWAPI::Unit> geysers;

	//build map
	//walk map
	//defense map, used for: defending decision
	//distance map, used for: expanding, cohesion
	extern bool build_map[256][256];
	extern bool walk_map[256][256];
	extern bool def_map[256][256];
	extern int dist_map[256][256];

	//map dimensions in tiles
	extern int w;
	extern int h;
	extern int wp;
	extern int hp;

	//positions
	extern BWAPI::Position start_pos;

}

//struct State
//{
//public:
//	std::string name = "WillyT";
//	BWAPI::Race race = BWAPI::Races::Terran;
//	std::string enemy_name = "hello world";
//	BWAPI::Race enemy_race = BWAPI::Races::Unknown;
//
//	int strategy = 0;
//
//	bool is_defending = false;
//	bool is_attacking = false;
//	bool is_swarming  = false;
//	bool has_militia  = false;
//};