#include "MiningManager.h"

void MiningManager::check_gas(std::vector<Expo> &expolist) {
	if (willyt::refineries.empty() ||
		!willyt::refineries.back()->isCompleted()) {
		return;
	}
	int t = BWAPI::Broodwar->elapsedTime();
	unsigned i = 0;
	for (Expo &my_expo : expolist) {
		i += my_expo.gas_miners.size();
	}
	if (BWAPI::Broodwar->self()->gas() < t / 4 && i < 3 * willyt::refineries.size()) {
		append_gas_miner(expolist);
	}
	if (BWAPI::Broodwar->self()->gas() > t / 2 && i > 0) {
		remove_gas_miner(expolist);
	}
}

void MiningManager::append_gas_miner(std::vector<Expo> &expolist) {
	for (Expo &expo : expolist) {
		for (BWAPI::Unit &geys : expo.geysers) {
			if (geys->getType() == BWAPI::UnitTypes::Resource_Vespene_Geyser ||
				geys->isBeingGathered()) {
				continue;
			}
			for (BWAPI::Unit &work : expo.min_miners) {
				if (work->isGatheringMinerals() &&
					!work->isCarryingMinerals()) {
					work->gather(geys, false);
					//BWAPI::Broodwar->printf("append scv to gas");
					return;
				}
			}
		}
	}
}

void MiningManager::remove_gas_miner(std::vector<Expo> &expolist) {
	for (Expo &expo : expolist) {
		for (BWAPI::Unit &work : expo.gas_miners) {
			if (!work->isCarryingGas()) {
				work->gather(expo.minerals.back(), false);
				//BWAPI::Broodwar->printf("remove scv from gas");
				return;
			}
		}
	}
}

void MiningManager::check_min(std::vector<Expo> &expolist) {
	for (Expo &e0 : expolist) {
		if (!e0.is_owned) { continue; }
		if (e0.min_miners.size() > 0 &&
			e0.min_miners.size() > 2 * e0.minerals.size() + 0) {
			for (Expo &e1 : expolist) {
				if (!e1.is_owned) { continue; }
				if (e1.min_miners.size() < 2 * e1.minerals.size() - 4) {
					e0.min_miners.front()->gather(e1.minerals.front(), false);
					//BWAPI::Broodwar->printf("transfer miner");
					return;
				}
			}
		}
	}
}