#include "Marine.h"

Marine::Marine(BWAPI::Unit my_unit, BWAPI::Position my_pos) {
	id = my_unit->getID();
	unit = my_unit;
	retreat_queue = 0;
	start_pos = my_pos;
}

void Marine::stim() {
	if (unit->isAttacking() &&
		!unit->isStimmed() &&
		unit->getHitPoints() >= 40)
		unit->useTech(BWAPI::TechTypes::Stim_Packs);
}

void Marine::retreat() {
	if (unit->isAttackFrame())
		return;
	if (retreat_queue == 1 && last_attack)
		unit->attack(last_attack);
	if (retreat_queue > 0) {
		retreat_queue--;
		return;
	}
	for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsInRadius(unit->getPosition(), 96))
		if (u->getPlayer()->isEnemy(BWAPI::Broodwar->self()) &&
			u->getType().groundWeapon() != BWAPI::WeaponTypes::None)
			perform_retreat(u);
}

void Marine::perform_retreat(BWAPI::Unit my_enemy) {
	if (unit->getPosition().getApproxDistance(start_pos) > 256) {
		unit->move(start_pos);
		retreat_queue = 40;
	}
	else {
		unit->move(find_position(my_enemy));
		retreat_queue = 20;
	}
	last_attack = my_enemy->getPosition();
}

BWAPI::Position Marine::find_position(BWAPI::Unit my_enemy) {
	int x1 = unit->getPosition().x;
	int y1 = unit->getPosition().y;
	int x2 = my_enemy->getPosition().x;
	int y2 = my_enemy->getPosition().y;
	double d = 1 + unit->getDistance(my_enemy);
	double m = 32 / d;
	int x = x1 - (int)(m * (x2 - x1));
	int y = y1 - (int)(m * (y2 - y1));
	return BWAPI::Position{ x, y };
}