#include "MapUtilities.h"

void show_map(bool(&my_map)[256][256], bool bool_modus) {
	int x0 = BWAPI::Broodwar->getScreenPosition().x / 32;
	int y0 = BWAPI::Broodwar->getScreenPosition().y / 32;
	int x1 = x0 + 20;
	int y1 = y0 + 15;
	if (x1 > willyt::w) { x1 = willyt::w; }
	if (y1 > willyt::h) { y1 = willyt::h; }

	for (int y = y0; y < y1; ++y) {
		for (int x = x0; x < x1; ++x) {
			if (my_map[y][x] == bool_modus) {
				int xd = x * 32;
				int yd = y * 32;
				BWAPI::Broodwar->drawLineMap(xd, yd, xd + 31, yd + 31, 111);
			}
		}
	}
}

void set_map_area(bool(&my_map)[256][256], int x0, int y0, int dx, int dy, bool v) {
	int x1 = x0 + dx;
	int y1 = y0 + dy;
	for (int y = y0; y < y1; ++y) {
		for (int x = x0; x < x1; ++x) {
			my_map[y][x] = v;
		}
	}
}

void set_map_area_unit(bool(&my_map)[256][256], BWAPI::Unit u, bool v) {
	int x0 = u->getTilePosition().x;
	int y0 = u->getTilePosition().y;
	int x1 = x0 + u->getType().tileWidth();
	int y1 = y0 + u->getType().tileHeight();
	for (int y = y0; y < y1; ++y) {
		for (int x = x0; x < x1; ++x) {
			my_map[y][x] = v;
		}
	}
}

bool check_build_area(int x0, int y0, int w, int h) {
	for (int y = y0; y < y0 + h; ++y)
		for (int x = x0; x < x0 + w; ++x)
			if (!willyt::build_map[y][x])
				return false;
	return true;
}