#pragma once
#include <BWAPI.h>
#include "Namespace.h"
#include "Expo.h"
#include "MapUtilities.h"

// 2018-06-29: start own map analysis

struct MapAnalysis {

public:
	void create_all_maps();
	void add_def_map(BWAPI::TilePosition tile, BWAPI::UnitType type, int r);
	void fill_build_map(std::vector<Expo> &expolist);

private:
	void create_build_map();
	void create_walk_map();
	bool tile_is_walkable(int x, int y);

	void clear_map(bool(&my_map)[256][256]);
	void create_dist_map(int(&my_map)[256][256], int x0, int y0);
	void fill_dist_map(int(&my_map)[256][256], int y, int x);
	bool is_valid(int(&my_map)[256][256], int y, int x);

	void create_grid_image();
	void create_dist_image();

};