#include "MapAnalysis.h"

void MapAnalysis::create_all_maps() {
	BWAPI::TilePosition t = BWAPI::Broodwar->self()->getStartLocation();
	willyt::w = BWAPI::Broodwar->mapWidth();
	willyt::h = BWAPI::Broodwar->mapHeight();
	willyt::wp = 32 * willyt::w;
	willyt::hp = 32 * willyt::h;
	willyt::start_pos = BWAPI::Position{ 32 * t.x + 64, 32 * t.y + 48 };

	create_build_map();
	create_walk_map();
	create_dist_map(willyt::dist_map, t.x+1, t.y+1);
	clear_map(willyt::def_map);

	//create_grid_image();
	//create_dist_image();
}

void MapAnalysis::create_build_map() {
	for (int y = 0; y < willyt::h; ++y)
		for (int x = 0; x < willyt::w; ++x)
			willyt::build_map[y][x] = BWAPI::Broodwar->isBuildable(x, y);
	//BWAPI::Broodwar->printf("created build grid");
}

void MapAnalysis::create_walk_map() {
	for (int y = 0; y < willyt::h; ++y)
		for (int x = 0; x < willyt::w; ++x)
			willyt::walk_map[y][x] = tile_is_walkable(x, y);
	//BWAPI::Broodwar->printf("created walk grid");
}

bool MapAnalysis::tile_is_walkable(int x, int y) {
	int z = 0;
	if (BWAPI::Broodwar->isWalkable(4 * x + 0, 4 * y + 0)) { ++z; }
	if (BWAPI::Broodwar->isWalkable(4 * x + 3, 4 * y + 0)) { ++z; }
	if (BWAPI::Broodwar->isWalkable(4 * x + 0, 4 * y + 3)) { ++z; }
	if (BWAPI::Broodwar->isWalkable(4 * x + 3, 4 * y + 3)) { ++z; }
	if (z == 4) { return true; }
	else { return false; }
}

void MapAnalysis::clear_map(bool(&my_map)[256][256]) {
	for (int y = 0; y < 256; ++y)
		for (int x = 0; x < 256; ++x)
			my_map[y][x] = false;
}

void MapAnalysis::create_dist_map(int(&my_map)[256][256], int x0, int y0) {
	for (int y = 0; y < willyt::h; ++y)
		for (int x = 0; x < willyt::w; ++x)
			my_map[y][x] = -1;

	my_map[y0][x0] = 0;
	for (int i = 0; i < 1024; ++i)
		for (int y = 0; y < willyt::h; ++y)
			for (int x = 0; x < willyt::w; ++x)
				if (my_map[y][x] == i)
					fill_dist_map(my_map, y, x);
	//BWAPI::Broodwar->printf("created distance grid");
}

void MapAnalysis::fill_dist_map(int(&my_map)[256][256], int y, int x) {
	int d = my_map[y][x];
	if (is_valid(my_map, y + 1, x)) { my_map[y + 1][x] = d + 2; }
	if (is_valid(my_map, y - 1, x)) { my_map[y - 1][x] = d + 2; }
	if (is_valid(my_map, y, x + 1)) { my_map[y][x + 1] = d + 2; }
	if (is_valid(my_map, y, x - 1)) { my_map[y][x - 1] = d + 2; }
	if (is_valid(my_map, y + 1, x + 1)) { my_map[y + 1][x + 1] = d + 3; }
	if (is_valid(my_map, y - 1, x + 1)) { my_map[y - 1][x + 1] = d + 3; }
	if (is_valid(my_map, y + 1, x - 1)) { my_map[y + 1][x - 1] = d + 3; }
	if (is_valid(my_map, y - 1, x - 1)) { my_map[y - 1][x - 1] = d + 3; }
}

bool MapAnalysis::is_valid(int(&my_map)[256][256], int y, int x) {
	if (y >= 0 && y < willyt::h &&
		x >= 0 && x < willyt::w &&
		willyt::walk_map[y][x] &&
		my_map[y][x] == -1)
		return true;
	return false;
}

void MapAnalysis::create_grid_image() {
	const char* my_path = "K:\\bwapi\\map_grid.pgm";
	/*FILE *my_file = fopen(my_path, "wb");
	fprintf(my_file, "P2 %d %d 2", willyt::w, willyt::h);

	for (int y = 0; y < willyt::h; ++y) {
		fprintf(my_file, "\n");
		for (int x = 0; x < willyt::w; ++x) {
			char* z = "0 ";
			if (walk_grid[y][x]) { z = "1 "; }
			if (build_grid[y][x]) { z = "2 "; }
			fprintf(my_file, z);
		}
	}
	fclose(my_file);*/
	BWAPI::Broodwar->printf(my_path);
}

void MapAnalysis::create_dist_image() {
	const char* my_path = "K:\\bwapi\\map_dist.pgm";
	/*FILE *my_file = fopen(my_path, "wb");
	fprintf(my_file, "P2 %d %d 511", willyt::w, willyt::h);

	for (int y = 0; y < willyt::h; ++y) {
		fprintf(my_file, "\n");
		for (int x = 0; x < willyt::w; ++x) {
			int z = dist_grid[y][x];
			if (z == -1) { fprintf(my_file, "0 "); }
			else { fprintf(my_file, "%d ", 511 - z); }
		}
	}
	fclose(my_file);*/
	BWAPI::Broodwar->printf(my_path);
}

void MapAnalysis::add_def_map(BWAPI::TilePosition tile, BWAPI::UnitType type, int r) {
	int x0 = tile.x - r;
	int y0 = tile.y - r;
	int x1 = tile.x + type.tileWidth() + r;
	int y1 = tile.y + type.tileHeight() + r;

	for (int y = y0; y < y1; ++y) {
		if (y < 0 || y >= willyt::h) { continue; }

		int x0r = x0;
		int x1r = x1;
		if (y == y0 || y == y1 - 1) {
			x0r = x0 + 3;
			x1r = x1 - 3;
		}
		else if (y == y0 + 1 || y == y1 - 2) {
			x0r = x0 + 2;
			x1r = x1 - 2;
		}
		else if (y == y0 + 2 || y == y1 - 3) {
			x0r = x0 + 1;
			x1r = x1 - 1;
		}
		for (int x = x0r; x < x1r; ++x) {
			if (x < 0 || x >= willyt::w) { continue; }
			willyt::def_map[y][x] = true;
		}
	}
}

void MapAnalysis::fill_build_map(std::vector<Expo> &expolist) {
	for (BWAPI::Unit unit : BWAPI::Broodwar->getNeutralUnits()) {
		if (!unit->getType().isBuilding()) { continue; }
		set_map_area_unit(willyt::build_map, unit, false);
	}
	for (Expo &expo : expolist) {
		set_map_area(willyt::build_map, expo.tile.x, expo.tile.y, 6, 3, false);
	}
}


