#include "Info.h"

void Info::display(EnemyList &el) {

	BWAPI::Broodwar->drawTextScreen(10, 10, "WillyT vs %s", el.name.c_str());
	unsigned min = BWAPI::Broodwar->elapsedTime() / 60;
	unsigned sec = BWAPI::Broodwar->elapsedTime() % 60;
	BWAPI::Broodwar->drawTextScreen(10, 20, "%02d:%02d", min, sec);

	draw_tech(10, 40, "Stim", BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Stim_Packs));
	draw_tech(40, 40, "U238", BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::U_238_Shells));
	draw_upgr(70, 40, BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Terran_Infantry_Weapons));
	draw_upgr(90, 40, BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Terran_Infantry_Armor));
	draw_tech(10, 50, "siege", BWAPI::Broodwar->self()->hasResearched(BWAPI::TechTypes::Tank_Siege_Mode));
	draw_tech(40, 50, "range", BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Charon_Boosters));
	draw_upgr(70, 50, BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Terran_Vehicle_Weapons));
	draw_upgr(90, 50, BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Terran_Vehicle_Plating));

	int bio_size = willyt::marines.size() + willyt::firebats.size() + willyt::medics.size();
	int mech_size = 2 * willyt::siegetanks.size() + 2 * willyt::goliaths.size();
	BWAPI::Broodwar->drawTextScreen(10, 70, "willyt");
	BWAPI::Broodwar->drawTextScreen(10, 80, "%d / %d WORK", willyt::scvs.size(), willyt::mining_supply);
	BWAPI::Broodwar->drawTextScreen(10, 90, "%d / %d BIO", bio_size, willyt::attack_supply);
	BWAPI::Broodwar->drawTextScreen(10, 100, "%d / %d MECH", mech_size, willyt::attack_supply);

	BWAPI::Broodwar->drawTextScreen(10, 120, el.name.c_str());
	BWAPI::Broodwar->drawTextScreen(10, 130, "%d buildings", el.positions.size());
	BWAPI::Broodwar->drawTextScreen(10, 140, "%d work supply", el.supply_work / 2);
	BWAPI::Broodwar->drawTextScreen(10, 150, "%d air supply", el.supply_air / 2);
	BWAPI::Broodwar->drawTextScreen(10, 160, "%d small supply", el.supply_small / 2);
	BWAPI::Broodwar->drawTextScreen(10, 170, "%d army supply", el.supply_army / 2);
	BWAPI::Broodwar->drawTextScreen(10, 180, "%d cloak supply", el.supply_cloak / 2);

}

void Info::draw_tech(int x, int y, const char* t, bool b) {
	if (b) {
		BWAPI::Broodwar->drawBoxScreen(x, y + 2, x + 28, y + 12, 151, true);
		BWAPI::Broodwar->drawTextScreen(x + 2, y, t);
	}
}

void Info::draw_upgr(int x, int y, int l) {
	if (l > 0) {
		BWAPI::Broodwar->drawBoxScreen(x, y + 2, x + 18, y + 12, 151, true);
		BWAPI::Broodwar->drawTextScreen(x + 2, y, "+%d", l);
	}
}

void Info::draw_256_colors() {
	for (int x = 0; x < 16; ++x) {
		for (int y = 0; y < 16; ++y) {
			int x0 = 16 * x;
			int y0 = 16 * y;
			BWAPI::Broodwar->drawBoxScreen(x0, y0, x0+16, y0+16, x+y*16, true);
		}
	}
}