#include "Firebat.h"

Firebat::Firebat(BWAPI::Unit my_unit, BWAPI::Position my_pos) {
	id = my_unit->getID();
	unit = my_unit;
	start_pos = my_pos;
	retreat_queue = 0;
}

void Firebat::retreat() {
	if (!unit->isCompleted() ||
		unit->isAttackFrame())
		return;
	if (retreat_queue == 1 && last_attack)
		unit->attack(last_attack);
	if (retreat_queue > 0) {
		retreat_queue--;
		if (last_attack && unit->getHitPoints() > 20) {
			unit->attack(last_attack);
			retreat_queue = 0;
		}
		return;
	}
	if (unit->getHitPoints() < 20 &&
		unit->getPosition().getApproxDistance(start_pos) > 256) {
		unit->move(start_pos);
		retreat_queue = 40;
		last_attack = unit->getPosition();
		//Broodwar->sendText("Firebat fall back.");
	}
}