#include "ExpoList.h"

void ExpoList::occupy_expo(BWAPI::TilePosition &tile) {
	for (Expo &my_expo : all) {
		if (my_expo.tile == tile) {
			for (BWAPI::Unit &my_min : my_expo.minerals) {
				if (my_min->exists()) { willyt::minerals.push_back(my_min); }
			}
			for (BWAPI::Unit &my_gey : my_expo.geysers) {
				if (my_gey->exists()) { willyt::geysers.push_back(my_gey); }
			}
			my_expo.is_owned = true;
			BWAPI::Broodwar->printf("Occupying expo at [%d, %d].", tile.x, tile.y);
		}
	}
}

void ExpoList::desert_expo(BWAPI::TilePosition &tile) {
	for (Expo &my_expo : all) {
		if (my_expo.tile == tile) {
			for (BWAPI::Unit &my_min : my_expo.minerals) {
				vector_remove_unit(willyt::minerals, my_min);
			}
			for (BWAPI::Unit &my_gey : my_expo.geysers) {
				vector_remove_unit(willyt::geysers, my_gey);
			}
			my_expo.is_owned = false;
			BWAPI::Broodwar->printf("Deserting expo at [%d, %d].", tile.x, tile.y);
		}
	}
}

void ExpoList::mined_out(BWAPI::Unit my_min) {
	for (Expo &expo : all) {
		if (expo.posi.getApproxDistance(my_min->getPosition()) < 512) {
			vector_remove_unit(expo.minerals, my_min);
		}
	}
	vector_remove_unit(willyt::minerals, my_min);
	//BWAPI::Broodwar->printf("mineral patch mined out");
}

void ExpoList::update() {
	for (Expo &expo : all) {
		if (!expo.is_owned) { continue; }
		expo.min_miners.clear();
		expo.gas_miners.clear();

		//for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsInRadius(expo.posi, 256)) {
		for (SCV &scv : willyt::scvs) {
			if (scv.unit->getDistance(expo.posi) < 256) {
				if (scv.unit->isGatheringMinerals())	{ expo.min_miners.push_back(scv.unit); }
				if (scv.unit->isGatheringGas())			{ expo.gas_miners.push_back(scv.unit); }
			}
		}
	}
}

void ExpoList::draw_expos() {
	for (Expo &expo : all) {
		if (!expo.is_owned) { continue; }
		draw_tile_box(expo.tile, 4, 3, 19);
		BWAPI::Broodwar->drawCircleMap(expo.posi, 20, 19, true);
		BWAPI::Broodwar->drawTextMap(expo.tpos_min, "min: %d", expo.min_miners.size());
		BWAPI::Broodwar->drawTextMap(expo.tpos_gas, "gas: %d", expo.gas_miners.size());
	}
}