#include "ExpoFinder.h"

void ExpoFinder::check(std::vector<Expo> &expolist, std::vector<BWAPI::Position> &enbulist) {
	if (BWAPI::Broodwar->elapsedTime() > 900) {
		remove_mineral_blocks();
	}
	if (BWAPI::Broodwar->elapsedTime() > 600 &&
		willyt::refineries.size() < willyt::geysers.size() &&
		BWAPI::Broodwar->self()->minerals() > 200 &&
		BWAPI::Broodwar->self()->gas() < 400) {
		check_additional_refineries();
	}
	if (BWAPI::Broodwar->elapsedTime() < 600 ||
		willyt::minerals.size() >= 20 ||
		BWAPI::Broodwar->self()->minerals() < 400) {
		return;
	}
	BWAPI::TilePosition enemy_center = calc_enemy_center(enbulist);
	BWAPI::TilePosition my_tile;
	BWAPI::TilePosition min_tile;
	int my_dist = NULL;
	int min_dist = NULL;

	for (Expo &my_expo : expolist) {
		if (my_expo.is_owned ||
			my_expo.is_enemy ||
			my_expo.is_island ||
			my_expo.minerals.size() < 3) {
			continue;
		}
		my_tile = my_expo.tile;
		my_dist = willyt::dist_map[my_tile.y][my_tile.x];
		if (my_dist < 0) {
			continue;
		}
		my_dist = my_dist - 2 * my_tile.getApproxDistance(enemy_center);

		if (min_dist == NULL ||
			min_dist > my_dist) {
			min_dist = my_dist;
			min_tile = my_tile;
		}
	}
	if (min_tile != BWAPI::TilePositions::Unknown && min_dist) {
		choose_scv(min_tile)->set_build_mission(BWAPI::UnitTypes::Terran_Command_Center, min_tile);
	}
}

BWAPI::TilePosition ExpoFinder::calc_enemy_center(std::vector<BWAPI::Position> &enbulist) {
	int x = 16* BWAPI::Broodwar->mapWidth();
	int y = 16* BWAPI::Broodwar->mapHeight();
	int q = 32 + 32 * enbulist.size();
	for (BWAPI::Position &p : enbulist) {
		x += p.x;
		y += p.y;
	}
	return BWAPI::TilePosition(x/q, y/q);
}

void ExpoFinder::remove_mineral_blocks() {
	for (BWAPI::Unit n : BWAPI::Broodwar->getNeutralUnits()) {
		if (n->getType().isMineralField() &&
			n->getResources() == 0) {
			choose_scv(n->getTilePosition())->unit->gather(n, false);
			BWAPI::Broodwar->printf("remove zero mineral block");
			return;
		}
	}
}

void ExpoFinder::check_additional_refineries() {
	BWAPI::UnitType my_type = BWAPI::UnitTypes::Terran_Refinery;
	for (BWAPI::Unit &g : willyt::geysers) {
		if (g->getType() != my_type &&
			g->getResources() >= 500) {
			BWAPI::TilePosition my_tile = g->getTilePosition();
			choose_scv(my_tile)->set_build_mission(my_type, my_tile);
			BWAPI::Broodwar->printf("build additional refinery");
			return;
		}
	}
};